<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link></p>

</li>
<li>
<p><router-link to="#zipkin-tracing" @click.native="this.scrollFix('#zipkin-tracing')">Zipkin Tracing</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Distributed tracing is a critical feature of microservice based applications, since it traces workflow both
within a service and across multiple services. This provides insight to sequence and timing data for specific blocks of work,
which helps you identify performance and operational issues.
Helidon includes support for distributed tracing through its own API, backed by either
through the <a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a>, or by
<a target="_blank" href="https://opentracing.io">OpenTracing API</a>. Tracing is integrated with WebServer and Security.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon Tracing
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;    <span class="conum" data-value="1" />
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon tracing dependency.</li>
<li data-value="2">Observability dependencies for tracing.</li>
</ul>

<p>For further processing of the tracing data, different providers are used.</p>

<p>For Jaeger:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Zipkin:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For OpenTelemetry:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-opentelemetry&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For OpenTracing:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-opentracing&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>This section explains a few concepts that you need to understand before you get started with tracing.</p>

<ul class="ulist">
<li>
<p>In the context of this document, a <em>service</em> is synonymous with an application.</p>

</li>
<li>
<p>A <em>span</em> is the basic unit of work done within a single service, on a single host.
Every span has a name, starting timestamp, and duration.
For example, the work done by a REST endpoint is a span.
A span is associated to a single service, but its descendants can belong to different services and hosts.</p>

</li>
<li>
<p>A <em>trace</em> contains a collection of spans from one or more services, running on one or more hosts. For example,
if you trace a service endpoint that calls another service, then the trace would contain spans from both services.
Within a trace, spans are organized as a directed acyclic graph (DAG) and
can belong to multiple services, running on multiple hosts.</p>

</li>
<li>
<p><em>Baggage</em> is a collection of key-value pairs associated with a span.</p>

</li>
<li>
<p><em>Span context</em> captures data about a span not related to its duration, such as the tracer ID, the span ID, and baggage.</p>

</li>
</ul>

<p>Support for specific tracers is abstracted. Your application can depend on
the Helidon abstraction layer and provide a specific tracer implementation as a Java
<code>ServiceLoader</code> service.
Helidon provides such an implementation for:</p>

<ul class="ulist">
<li>
<p>OpenTracing tracers, either using the <code>GlobalTracer</code>, provider resolver approach, or explicitly using Zipkin tracer</p>

</li>
<li>
<p>OpenTelemetry tracers, either using the global OpenTelemetry instance, or explicitly using Jaeger tracer</p>

</li>
</ul>


<h3 id="_setup_webserver">Setup WebServer</h3>
<div class="section">
<markup
lang="java"
title="Configuring <code>Tracer</code>"
>Tracer tracer = TracerBuilder.create("helidon") <span class="conum" data-value="1" />
        .build();

WebServer.builder()
        .addFeature(ObserveFeature.builder()
                            .addObserver(TracingObserver.create(tracer)) <span class="conum" data-value="2" />
                            .build())
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Create a <code>Tracer</code>.</li>
<li data-value="2">Add an observability feature using the created <code>Tracer</code>.</li>
</ul>

</div>


<h3 id="_creating_custom_spans">Creating Custom Spans</h3>
<div class="section">
<p>To create a custom span from tracer:</p>

<markup
lang="java"

>Span span = tracer.spanBuilder("name") <span class="conum" data-value="1" />
        .tag("key", "value")
        .start();

try { <span class="conum" data-value="2" />
    // do some work
    span.end();
} catch (Throwable t) { <span class="conum" data-value="3" />
    span.end(t);
}</markup>

<ul class="colist">
<li data-value="1">Create span from tracer.</li>
<li data-value="2">Do some work and end span.</li>
<li data-value="3">End span with exception.</li>
</ul>

</div>


<h3 id="_handling_baggage">Handling Baggage</h3>
<div class="section">
<p>Your application can set and read baggage associated with a
<a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>Span</code></a>.
The <code>Span.baggage()</code> method returns a
<a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/WritableBaggage.html"><code>WritableBaggage</code></a> instance.</p>

<p>Further, Helidon also provides read-only access to baggage linked to
a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanContext.html"><code>SpanContext</code></a>.
For example, HTTP headers can convey trace ID, span ID, and baggage information and Helidon puts such information into a <code>SpanContext</code>.
Your code can create a <code>SpanContext</code> from other sources as well. The <code>SpanContext.baggage()</code> method returns a read-only <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Baggage.html"><code>Baggage</code></a> instance.</p>

<p>The JavaDoc for the types describes how to get and set baggage entries, get all the baggage keys, and check whether a baggage key exists in the baggage.</p>

</div>


<h3 id="Tracing-callbacks">Responding to Span Lifecycle Events</h3>
<div class="section">
<p>Applications and libraries can register listeners to be notified at several moments during the lifecycle of every span:</p>

<ul class="ulist">
<li>
<p>Before a new span starts</p>

</li>
<li>
<p>After a new span has started</p>

</li>
<li>
<p>After a span ends</p>

</li>
<li>
<p>After a span is activated (creating a new scope)</p>

</li>
<li>
<p>After a scope is closed</p>

</li>
</ul>

<p>The next sections explain how you can write and add a listener and what it can do. See the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> Javadoc for more information.</p>


<h4 id="_understanding_what_listeners_do">Understanding What Listeners Do</h4>
<div class="section">
<p>A listener cannot affect the lifecycle of a span or scope it is notified about, but it can add tags and events and update the baggage associated with a span.
Often a listener does additional work that does not change the span or scope such as logging a message.</p>

<p>When Helidon invokes the listener&#8217;s methods it passes proxies for the <code>Span.Builder</code>, <code>Span</code>, and <code>Scope</code> arguments. These proxies limit the access the listener has to the span builder, span, or scope, as summarized in the following table. If a listener method tries to invoke a forbidden operation, the proxy throws a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.ForbiddenOperationException.html"><code>SpanListener.ForbiddenOperationException</code></a> and Helidon then logs a <code>WARNING</code> message describing the invalid operation invocation.</p>

<div class="block-title"><span>Summary of Permitted Operations on Proxies Passed to Listeners</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Tracing type</th>
<th>Changes allowed</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>Span.Builder</code></a></td>
<td class="">Add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>Span</code></a></td>
<td class="">Retrieve and update baggage, add events, add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>Scope</code></a></td>
<td class="">none</td>
</tr>
</tbody>
</table>
</div>

<p>The following tables list specifically what operations the proxies permit.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>io.helidon.tracing.Span.Builder</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>build()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>end</code> methods</td>
<td class="">Ends the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>get()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>kind(Kind)</code></td>
<td class="">Sets the "kind" of span (server, client, internal, etc.)</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>parent(SpanContext)</code></td>
<td class="">Sets the parent of the span to be created from the builder.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start(Instant)</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>tag</code> methods</td>
<td class="">Add a tag to the builder before the span is built.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the builder to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy for it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>io.helidon.tracing.Span</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>activate()</code></td>
<td class="">Makes the span "current", returning a <code>Scope</code>.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>addEvent</code> methods</td>
<td class="">Associate a string (and optionally other info) with a span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns the <code>Baggage</code> instance associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>context()</code></td>
<td class="">Returns the <code>SpanContext</code> associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>status(Status)</code></td>
<td class="">Sets the status of the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class="">any <code>tag</code> method</td>
<td class="">Add a tag to the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the span to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy to it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>io.helidon.tracing.Scope</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>close()</code></td>
<td class="">Close the scope.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>isClosed()</code></td>
<td class="">Reports whether the scope is closed.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanContext.html"><code>io.helidon.tracing.SpanContext</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>asParent(Span.Builder)</code></td>
<td class="">Sets this context as the parent of a new span builder.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns <code>Baggage</code> instance associated with the span context.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>spanId()</code></td>
<td class="">Returns the span ID.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>traceId()</code></td>
<td class="">Returns the trace ID.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_adding_a_listener">Adding a Listener</h4>
<div class="section">

<h5 id="_explicitly_registering_a_listener_on_a_tracer">Explicitly Registering a Listener on a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html"><code>Tracer</code></a></h5>
<div class="section">
<p>Create a <code>SpanListener</code> instance and invoke the <code>Tracer#register(SpanListener)</code> method to make the listener known to that tracer.</p>

</div>


<h5 id="_automatically_registering_a_listener_on_all_tracer_instances">Automatically Registering a Listener on all <code>Tracer</code> Instances</h5>
<div class="section">
<p>Helidon also uses Java service loading to locate listeners and register them automatically on all <code>Tracer</code> objects.
Follow these steps to add a listener service provider.</p>

<ol style="margin-left: 15px;">
<li>
Implement the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> interface.

</li>
<li>
Declare your implementation as a service provider:
<ol style="margin-left: 15px;">
<li>
Create the file <code>META-INF/services/io.helidon.tracing.SpanListener</code> containing a line with the fully-qualified name of your class which implements <code>SpanListener</code>.

</li>
<li>
If your service has a <code>module-info.java</code> file add the following line to it:
<markup
lang="java"

>provides io.helidon.tracing.SpanListener with &lt;your-implementation-class&gt;;</markup>

</li>
</ol>

</li>
</ol>

<p>The <code>SpanListener</code> interface declares default no-op implementations for all the methods, so your listener can implement only the methods it needs to.</p>

<p>Helidon invokes each listener&#8217;s methods in the following order:</p>

<div class="block-title"><span>Order in which Helidon Invokes Listener Methods</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>When invoked</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>starting(Span.Builder&lt;?&gt; spanBuilder)</code></td>
<td class="">Just before a span is started from its builder.</td>
</tr>
<tr>
<td class=""><code>started(Span span)</code></td>
<td class="">Just after a span has started.</td>
</tr>
<tr>
<td class=""><code>activated(Span span, Scope scope)</code></td>
<td class="">After a span has been activated, creating a new scope. A given span might never be activated; it depends on the code.</td>
</tr>
<tr>
<td class=""><code>closed(Span span, Scope scope)</code></td>
<td class="">After a scope has been closed.</td>
</tr>
<tr>
<td class=""><code>ended(Span span)</code></td>
<td class="">After a span has ended successfully.</td>
</tr>
<tr>
<td class=""><code>ended(Span span, Throwable t)</code></td>
<td class="">After a span has ended unsuccessfully.</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>

</div>


<h2 id="_helidon_spans">Helidon Spans</h2>
<div class="section">

</div>


<h2 id="_traced_spans">Traced spans</h2>
<div class="section">
<p>The following table lists all spans traced by Helidon components:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>component</th>
<th>span name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>HTTP Request</code></td>
<td class="">The overall span of the Web Server from request initiation until response
Note that in <code>Zipkin</code> the name is replaced with <code>jax-rs</code> span name if <code>jax-rs</code> tracing
is used.</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-read</code></td>
<td class="">Span for reading the request entity</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-write</code></td>
<td class="">Span for writing the response entity</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security</code></td>
<td class="">Processing of request security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atn</code></td>
<td class="">Span for request authentication</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atz</code></td>
<td class="">Span for request authorization</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:response</code></td>
<td class="">Processing of response security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:outbound</code></td>
<td class="">Processing of outbound security</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class="">A generated name</td>
<td class="">Span for the resource method invocation, name is generated from class and method name</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class=""><code>jersey-client-call</code></td>
<td class="">Span for outbound client call</td>
</tr>
</tbody>
</table>
</div>

<p>Some of these spans <code>log</code> to the span. These log events can be (in most cases) configured:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 14.286%;">
<col style="width: 14.286%;">
<col style="width: 7.143%;">
<col style="width: 7.143%;">
<col style="width: 57.143%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>log name</th>
<th>configurable</th>
<th>enabled by default</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>handler.class</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Each handler has its class and event logged</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs either "status: PROCEED" or "status: DENY"</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>security.user</code></td>
<td class="">YES</td>
<td class="">NO</td>
<td class="">The username of the user if logged in</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>security.service</code></td>
<td class="">YES</td>
<td class="">NO</td>
<td class="">The name of the service if logged in</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
<tr>
<td class=""><code>security:atz</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
<tr>
<td class=""><code>security:outbound</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
</tbody>
</table>
</div>

<p>There are also tags that are set by Helidon components. These are not configurable.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>tag name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>component</code></td>
<td class="">name of the component - <code>helidon-webserver</code>, or <code>jaxrs</code> when using MP</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the request, such as <code>GET</code>, <code>POST</code></td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of the response</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.url</code></td>
<td class="">The path of the request (for SE without protocol, host and port)</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>error</code></td>
<td class="">If the request ends in error, this tag is set to <code>true</code>, usually accompanied by logs with details</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security.id</code></td>
<td class="">ID of the security context created for this request (if security is used)</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the client request</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of client response</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.url</code></td>
<td class="">Full URL of the request (such as <code><a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code>)</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The following configuration should be supported by all tracer implementations (if feasible)</p>

<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-export-batch-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Maximum Export Batch Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-queue-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximum Queue Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagation</code></td>
<td class=""><doc-view>
<p>PropagationFormat[&#93; (B3, B3_SINGLE, JAEGER, W3C)</p>

</doc-view>
</td>
<td class=""><code>JAEGER</code></td>
<td class=""><doc-view>
<p>Add propagation format to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schedule-delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>Schedule Delay of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>span-processor-type</code></td>
<td class=""><doc-view>
<p>SpanProcessorType (SIMPLE, BATCH)</p>

</doc-view>
</td>
<td class=""><code>batch</code></td>
<td class=""><doc-view>
<p>Span Processor type used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>


<h3 id="_traced_spans_configuration">Traced Spans Configuration</h3>
<div class="section">
<p>Each component and its spans can be configured using Config.
The traced configuration has the following layers:</p>

<ul class="ulist">
<li>
<p><code>TracingConfig</code> - the overall configuration of traced components of Helidon</p>

</li>
<li>
<p><code>ComponentTracingConfig</code> - a component of Helidon that traces spans (such as <code>web-server</code>, <code>security</code>, <code>jax-rs</code>)</p>

</li>
<li>
<p><code>SpanTracingConfig</code> - a single traced span within a component (such as <code>security:atn</code>)</p>

</li>
<li>
<p><code>SpanLogTracingConfig</code> - a single log event on a span (such as <code>security.user</code> in span <code>security:atn</code>)</p>

</li>
</ul>

<p>The components using tracing configuration use the
<code>TracingConfigUtil</code>. This uses the <code>io.helidon.common.Context</code> to retrieve
current configuration.</p>


<h4 id="_configuration_using_builder">Configuration Using Builder</h4>
<div class="section">
<p>Builder approach, example that disables a single span log event:</p>

<markup
lang="java"
title="Configure tracing using a builder"
>TracingConfig.builder()
        .addComponent(ComponentTracingConfig.builder("web-server")
                              .addSpan(SpanTracingConfig.builder("HTTP Request")
                                               .addSpanLog(SpanLogTracingConfig.builder("content-write")
                                                                   .enabled(false)
                                                                   .build())
                                               .build())
                              .build())
        .build();</markup>

</div>


<h4 id="_configuration_using_helidon_config">Configuration using Helidon Config</h4>
<div class="section">
<p>Tracing configuration can be defined in a config file.</p>

<markup
lang="yaml"
title="Tracing configuration"
>tracing:
    components:
      web-server:
        spans:
          - name: "HTTP Request"
            logs:
              - name: "content-write"
                enabled: false</markup>

<markup
lang="java"
title="Use the configuration in web server"
>Tracer tracer = TracerBuilder.create(config.get("tracing")).build(); <span class="conum" data-value="1" />
server.addFeature(ObserveFeature.builder()
                          .addObserver(TracingObserver.create(tracer)) <span class="conum" data-value="2" />
                          .build());</markup>

<ul class="colist">
<li data-value="1">Create <code>Tracer</code> using <code>TracerBuilder</code> from configuration.</li>
<li data-value="2">Add the <code>Tracer</code> as an observability feature.</li>
</ul>

</div>


<h4 id="_path_based_configuration_in_helidon_webserver">Path-based Configuration in Helidon WebServer</h4>
<div class="section">
<p>For Web Server we have path-based support for configuring tracing, in addition
to the configuration described above.</p>

<p>Configuration of path can use any path string supported by the
WebServer. The configuration itself has the same possibilities
 as traced configuration described above. The path-specific configuration
 will be merged with global configuration (path is the "newer" configuration, global is the "older")</p>

<markup
lang="yaml"
title="Configuration in YAML"
>tracing:
  paths:
    - path: "/favicon.ico"
      enabled: false
    - path: "/metrics"
      enabled: false
    - path: "/health"
      enabled: false
    - path: "/greet"
      components:
        web-server:
          spans:
          - name: "content-read"
            new-name: "read"
            enabled: false</markup>

</div>


<h4 id="_renaming_top_level_span_using_request_properties">Renaming top level span using request properties</h4>
<div class="section">
<p>To have a nicer overview in search pane of a tracer, you can customize the top-level span name using configuration.</p>

<p>Example:</p>

<markup
lang="yaml"
title="Configuration in YAML"
>tracing:
  components:
    web-server:
      spans:
      - name: "HTTP Request"
        new-name: "HTTP %1$s %2$s"</markup>

<p>This is supported ONLY for the span named "HTTP Request" on component "web-server".</p>

<p>Parameters provided:</p>

<ol style="margin-left: 15px;">
<li>
Method - HTTP method

</li>
<li>
Path - path of the request (such as '/greet')

</li>
<li>
Query - query of the request (may be null)

</li>
</ol>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_webclient_span_propagation">WebClient Span Propagation</h3>
<div class="section">
<p>Span propagation is supported with Helidon WebClient.
Tracing propagation is automatic as long as the current span context is available in Helidon Context
(which is automatic when running within a WebServer request).</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-webclient&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-webclient-tracing&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<markup
lang="java"
title="Tracing propagation with Helidon WebClient"
>WebClient client = WebClient.builder()
        .addService(WebClientTracing.create())
        .build();

String response = client.get()
        .uri(uri)
        .requestEntity(String.class);</markup>

</div>


<h3 id="jaeger-tracing">Jaeger Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_jaeger">Configuring Jaeger</h2>
<div class="section">
<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_2">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-export-batch-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Maximum Export Batch Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-queue-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximum Queue Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagation</code></td>
<td class=""><doc-view>
<p>PropagationFormat[&#93; (B3, B3_SINGLE, JAEGER, W3C)</p>

</doc-view>
</td>
<td class=""><code>JAEGER</code></td>
<td class=""><doc-view>
<p>Add propagation format to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schedule-delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>Schedule Delay of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>span-processor-type</code></td>
<td class=""><doc-view>
<p>SpanProcessorType (SIMPLE, BATCH)</p>

</doc-view>
</td>
<td class=""><code>batch</code></td>
<td class=""><doc-view>
<p>Span Processor type used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Jaeger configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
    service: "helidon-full-http"
    protocol: "https"
    host: "jaeger"
    port: 14240</markup>


<h3 id="jaeger-tracing-metrics">Jaeger Tracing Metrics</h3>
<div class="section">
<p>As the <router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link> section describes, you can use Jaeger tracing in your Helidon application.</p>

</div>


<h3 id="zipkin-tracing">Zipkin Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_zipkin">Configuring Zipkin</h2>
<div class="section">
<p>Zipkin tracer configuration</p>

<p>Type: io.opentracing.Tracer</p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_3">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>api-version</code></td>
<td class=""><doc-view>
<p>Version (V1, V2)</p>

</doc-view>
</td>
<td class=""><code>V2</code></td>
<td class=""><doc-view>
<p>Version of Zipkin API to use.
 Defaults to Version#V2.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Zipkin configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
  zipkin:
    service: "helidon-service"
    protocol: "https"
    host: "zipkin"
    port: 9987
    api-version: 1
    # this is the default path for API version 2
    path: "/api/v2/spans"
    tags:
      tag1: "tag1-value"
      tag2: "tag2-value"
    boolean-tags:
      tag3: true
      tag4: false
    int-tags:
      tag5: 145
      tag6: 741</markup>

<p>Example of Zipkin trace:</p>



<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="/images/webserver/zipkin.png" alt="Zipkin example" />
</v-card-text>
</v-card>


</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://opentracing.io/">Opentracing Project</a></p>

</li>
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a></p>

</li>
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a></p>

</li>
</ul>

</div>

</doc-view>
