<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>CircuitBreaker (faulttolerance) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.faulttolerance/io/helidon/faulttolerance/CircuitBreaker.html">io.helidon.faulttolerance.CircuitBreaker</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>fault-tolerance.circuit-breakers</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>How long to wait before transitioning from open to half-open state.</p>

<pre>@return delay</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>error-ratio</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>60</code></td>
<td class=""><doc-view>
<p>How many failures out of 100 will trigger the circuit to open.
 This is adapted to the #volume() used to handle the window of requests.
If errorRatio is 40, and volume is 10, 4 failed requests will open the circuit.
 Default is <code>DEFAULT_ERROR_RATIO</code>.</p>

<pre>@return percent of failure that trigger the circuit to open
@see #volume()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>success-threshold</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>How many successful calls will close a half-open circuit.
 Nevertheless, the first failed call will open the circuit again.
 Default is <code>DEFAULT_SUCCESS_THRESHOLD</code>.</p>

<pre>@return number of calls</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>volume</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>10</code></td>
<td class=""><doc-view>
<p>Rolling window size used to calculate ratio of failed requests.
 Default is <code>DEFAULT_VOLUME</code>.</p>

<pre>@return how big a window is used to calculate error errorRatio
@see #errorRatio()</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
