<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Retry (faulttolerance) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.faulttolerance/io/helidon/faulttolerance/Retry.html">io.helidon.faulttolerance.Retry</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>fault-tolerance.retries</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>calls</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>3</code></td>
<td class=""><doc-view>
<p>Number of calls (first try + retries).</p>

<pre>@return number of desired calls, must be 1 (means no retries) or higher.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.2S</code></td>
<td class=""><doc-view>
<p>Base delay between try and retry.
 Defaults to <code>200 ms</code>.</p>

<pre>@return delay between retries (combines with retry policy)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>delay-factor</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Delay retry policy factor. If unspecified (value of <code>-1</code>), Jitter retry policy would be used, unless
 jitter is also unspecified.</p>

<pre>Default when Retry.DelayingRetryPolicy is used is `2`.</pre>
<pre>@return delay factor for delaying retry policy</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>jitter</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT-1S</code></td>
<td class=""><doc-view>
<p>Jitter for Retry.JitterRetryPolicy. If unspecified (value of <code>-1</code>),
 delaying retry policy is used. If both this value, and #delayFactor() are specified, delaying retry policy
 would be used.</p>

<pre>@return jitter</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>overall-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT1S</code></td>
<td class=""><doc-view>
<p>Overall timeout of all retries combined.</p>

<pre>@return overall timeout</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
