<doc-view>

<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>MicroProfile configuration options:</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>mp.jwt.verify.publickey</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The property allows the Public Verification Key text itself to be supplied as a string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.publickey.location</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The property allows for an external or internal location of Public Verification Key to be specified. The value may be a relative path or a URL.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.publickey.algorithm</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The  configuration property allows for specifying which Public Key Signature Algorithm is supported by the MP JWT endpoint. This property can be set to either <code>RS256</code> or <code>ES256</code>. Default value is <code>RS256</code>. Support for the other asymmetric signature algorithms such as <code>RS512</code>, <code>ES512</code> and others is optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.issuer</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration key for expected issuer of incoming tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.audiences</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration key for expected audiences of incoming tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.token.age</code></td>
<td class="">int</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Max number of seconds since token issue time. If this number of second accedes configured value, validation will fail.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.clock.skew</code></td>
<td class="">int</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Number of seconds for the clock skew during the token age verification and expiry.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.token.cookie</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Cookie property name which is expected to contain a JWT token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.token.header</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Header name which is expected to contain a JWT token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.decrypt.key.location</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The property allows for an external or internal location of Private Decryption Key to be specified. The value may be a relative path or a URL.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.decrypt.key.algorithm</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The configuration property allows for specifying which key management algorithm is supported by the MP JWT endpoint. Supported algorithms are either <code>RSA-OAEP</code> or <code>RSA-OAEP-256</code>. If no algorithm is set, both algorithms must be accepted.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Helidon configuration options:</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>optional</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>If set to <code>true</code>, failure to authenticate will return <code>ABSTAIN</code> result instead of <code>FAILURE</code>. This is
an important distinction when more than one provider is used</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to attempt authentication</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to attempt identity propagation/JWT creation</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class="">string</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Whether we authenticate a user or a service (other option is SERVICE)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A group for configuring authentication of the request</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.verify-signature</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to verify signature in incoming JWT. If disabled, <em>ANY</em> JWT will be accepted</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwt-audience</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Expected audience of the JWT. If not defined, any audience is accepted (and we may accept JWT not inteded for us)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwk.resource</code></td>
<td class=""><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of the JWK to obtain key(s) to validate signatures of inbound token. The JWK should contain public keys.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler</code></td>
<td class="">string</td>
<td class=""><code>Authorization</code> header with `bearer ` prefix</td>
<td class=""><doc-view>
<p>A handler configuration for inbound token - e.g. how to extract it</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.header</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of a header the token is expected in</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.prefix</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Prefix before the token value (optional)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.regexp</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Regular expression to obtain the token, first matching group is used (optional)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A group for configuring outbound security</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwk.resource</code></td>
<td class=""><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of the JWK to use when generating tokens (follows the same rules as atn-token.jwk above). The JWK must contain private keys when using asymmetric ciphers.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwt-issuer</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>When we issue a new token, this is the issuer to be placed into it (validated by target service)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A group for configuring outbound rules (based on transport, host and.or path)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.name</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A short descriptive name for configured target service(s)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.transports</code></td>
<td class="">string</td>
<td class="">any</td>
<td class=""><doc-view>
<p>An array of transports this outbound matches (e.g. https)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.hosts</code></td>
<td class="">string</td>
<td class="">any</td>
<td class=""><doc-view>
<p>An array of hosts this outbound matches, may use * as a wild-card (e.g. *.oracle.com)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.paths</code></td>
<td class="">string</td>
<td class="">any</td>
<td class=""><doc-view>
<p>An array of paths on the host this outbound matches, may use * as a wild-card (e.g. /some/path/*)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.outbound-token</code></td>
<td class="">string</td>
<td class=""><code>Authorization</code> header with `bearer ` prefix</td>
<td class=""><doc-view>
<p>Configuration of outbound token handler (same as atn-token.handler)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.outbound-token.format</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Java text format for generating the value of outbound token header (e.g. "bearer %1$s")</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.jwk-kid</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>If this key is defined, we are generating a new token, otherwise we propagate existing. Defines the key id of a key definition in the JWK file to use for signing the outbound token</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.jwt-kid</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A key to use in the generated JWT - this is for the other service to locate the verification key in their JWK</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.jwt-audience</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience this key is generated for (e.g. <a target="_blank" href="http://www.example.org/api/myService" class="bare">http://www.example.org/api/myService</a>) - validated by the other service</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.jwt-not-before-seconds</code></td>
<td class="">string</td>
<td class=""><code>5</code></td>
<td class=""><doc-view>
<p>Makes this key valid this amount of seconds into the past. Allows a certain time-skew for the generated token to be valid before current time (e.g. when we expect a certain misalignment of clocks)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.outbound.*.jwt-validity-seconds</code></td>
<td class="">string</td>
<td class="">1 day</td>
<td class=""><doc-view>
<p>Token validity in seconds</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
