<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>OpenApiFeature (openapi) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeature.html">io.helidon.openapi.OpenApiFeature</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>openapi</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>CORS config.</p>

<pre>@return CORS config</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the feature should be enabled.</p>

<pre>@return `true` if enabled, `false` otherwise</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>manager</code></td>
<td class=""><doc-view>
<p>io.helidon.openapi.OpenApiManager (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>OpenAPI manager.</p>

<pre>@return the OpenAPI manager</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>permit-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow anybody to access the endpoint.</p>

<pre>@return whether to permit access to metrics endpoint to anybody, defaults to `true`
@see #roles()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Hints for role names the user is expected to be in.</p>

<pre>@return list of hints</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>services</code></td>
<td class=""><doc-view>
<p>io.helidon.openapi.OpenApiService[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>OpenAPI services.</p>

<pre>@return the OpenAPI services</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>static-file</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path of the static OpenAPI document file. Default types are <code>json</code>, <code>yaml</code>, and <code>yml</code>.</p>

<pre>@return location of the static OpenAPI document file</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/openapi</code></td>
<td class=""><doc-view>
<p>Web context path for the OpenAPI endpoint.</p>

<pre>@return webContext to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
