<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>FixedRate (scheduling) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.scheduling/io/helidon/scheduling/FixedRate.html">io.helidon.scheduling.FixedRate</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Required configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>delay</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Fixed rate delay between each invocation. Time unit is by default java.util.concurrent.TimeUnit#SECONDS,
 can be specified with io.helidon.scheduling.Scheduling.FixedRateBuilder#timeUnit(java.util.concurrent.TimeUnit).</p>

<pre>@return delay between each invocation</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>delay-type</code></td>
<td class=""><doc-view>
<p>DelayType (SINCE_PREVIOUS_START, SINCE_PREVIOUS_END)</p>

</doc-view>
</td>
<td class=""><code>@io.helidon.scheduling.FixedRate.DelayType@.SINCE_PREVIOUS_START</code></td>
<td class=""><doc-view>
<p>Configure whether the delay between the invocations should be calculated from the time when previous task started or ended.
 Delay type is by default FixedRate.DelayType#SINCE_PREVIOUS_START.</p>

<pre>@return delay type</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>initial-delay</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Initial delay of the first invocation. Time unit is by default java.util.concurrent.TimeUnit#SECONDS,
 can be specified with
 io.helidon.scheduling.Scheduling.FixedRateBuilder#timeUnit(java.util.concurrent.TimeUnit) timeUnit().</p>

<pre>@return initial delay value</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>time-unit</code></td>
<td class=""><doc-view>
<p>TimeUnit (NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS)</p>

</doc-view>
</td>
<td class=""><code>TimeUnit.SECONDS</code></td>
<td class=""><doc-view>
<p>java.util.concurrent.TimeUnit TimeUnit used for interpretation of values provided with
 io.helidon.scheduling.Scheduling.FixedRateBuilder#delay(long)
 and io.helidon.scheduling.Scheduling.FixedRateBuilder#initialDelay(long).</p>

<pre>@return time unit for interpreting values
        in io.helidon.scheduling.Scheduling.FixedRateBuilder#delay(long)
        and io.helidon.scheduling.Scheduling.FixedRateBuilder#initialDelay(long)</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
