<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>HeaderAtnProvider (security.providers.header) Configuration</dt>
<dd slot="desc"><p>Security provider that extracts a username (or service name) from a header.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.header/io/helidon/security/providers/header/HeaderAtnProvider.html">io.helidon.security.providers.header.HeaderAtnProvider</a></p>

<markup
lang="text"
title="Config key"
>header-atn</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>atn-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to extract username from request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to authenticate requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the username cannot be extracted.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundTarget">OutboundTarget[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure outbound target for identity propagation.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to create outbound headers to propagate identity.
 If not defined, #atnTokenHandler will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to propagate identity.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
