<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>InboundClientDefinition (security.providers.httpsign) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.httpsign/io/helidon/security/providers/httpsign/InboundClientDefinition.html">io.helidon.security.providers.httpsign.InboundClientDefinition</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Algorithm of signature used by this client.
 Currently supported:</p>

<ul class="ulist">
<li>
<p>rsa-sha256 - asymmetric based on public/private keys</p>

</li>
<li>
<p>hmac-sha256 - symmetric based on a shared secret</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>hmac.secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Helper method to configure a password-like secret (instead of byte based #hmacSecret(byte[]).
 The password is transformed to bytes with StandardCharsets#UTF_8 charset.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The key id of this client to map to this signature validation configuration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The principal name of the client, defaults to keyId if not configured.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>SERVICE</code></td>
<td class=""><doc-view>
<p>The type of principal we have authenticated (either user or service, defaults to service).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>public-key</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_pki_Keys">Keys</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>For algorithms based on public/private key (such as rsa-sha256), this provides access to the public key of the client.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
