<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Tracer (tracing) Configuration</dt>
<dd slot="desc"><p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-export-batch-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Maximum Export Batch Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-queue-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximum Queue Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagation</code></td>
<td class=""><doc-view>
<p>PropagationFormat[&#93; (B3, B3_SINGLE, JAEGER, W3C)</p>

</doc-view>
</td>
<td class=""><code>JAEGER</code></td>
<td class=""><doc-view>
<p>Add propagation format to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schedule-delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>Schedule Delay of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>span-processor-type</code></td>
<td class=""><doc-view>
<p>SpanProcessorType (SIMPLE, BATCH)</p>

</doc-view>
</td>
<td class=""><code>batch</code></td>
<td class=""><doc-view>
<p>Span Processor type used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
