<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>SecurityFeature (webserver.security) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.security/io/helidon/webserver/security/SecurityFeature.html">io.helidon.webserver.security.SecurityFeature</a></p>

<markup
lang="text"
title="Config key"
>security</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>defaults</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_security_SecurityHandler">SecurityHandler</router-link></p>

</doc-view>
</td>
<td class=""><code>SecurityHandler.create()</code></td>
<td class=""><doc-view>
<p>The default security handler.</p>

<pre>@return security handler defaults</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>paths</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_security_PathsConfig">PathsConfig[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration for webserver paths.</p>

<pre>@return path configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_Security">Security</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Security associated with this feature.
 If not specified here, the feature uses security registered with
 io.helidon.common.context.Contexts#globalContext(), if not found, it creates a new
 instance from root of configuration (using <code>security</code> key).</p>

<pre>This configuration allows usage of a different security instance for a specific security feature setup.</pre>
<pre>@return security instance to be used to handle security in this feature configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>800.0</code></td>
<td class=""><doc-view>
<p>Weight of the security feature. Value is:
 <code>io.helidon.webserver.security.SecurityFeature#WEIGHT</code>.</p>

<pre>@return weight of the feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
