<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon MP Quickstart</dt>
<dd slot="desc"><p>This guide describes a basic example of an Helidon MP application using Docker and Kubernetes.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 5 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the
 <router-link to="/mp/guides/quickstart">Helidon MP Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>

</div>


<h2 id="_generate_the_project">Generate the Project</h2>
<div class="section">
<p>Generate the project sources using one (or both) of the Helidon Maven
 archetypes. The result is a simple project that shows the basics of configuring
 the WebServer and implementing basic routing rules.</p>

<markup
lang="bash"
title="Run the Maven archetype"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-mp \
    -DarchetypeVersion=4.0.8 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-mp \
    -Dpackage=io.helidon.examples.quickstart.mp</markup>

<p>The archetype generates a Maven project in your current directory
(for example, <code>helidon-quickstart-mp</code>). Change into this directory.</p>

<markup
lang="bash"

>cd helidon-quickstart-mp</markup>

<div class="admonition tip">
<p class="admonition-inline">If you want to use the generated project as a starter
for your own application, then you can replace groupId, artifactId
and package with values appropriate for your application.</p>
</div>

<markup
lang="bash"
title="Build the Application"
>mvn package</markup>

<p>The project builds an application jar for the example and saves all runtime
dependencies in the <code>target/libs</code> directory. This means you can easily start the
 application by running the application jar file:</p>

<markup
lang="bash"
title="Run the application"
>java -jar target/helidon-quickstart-mp.jar</markup>

<p>The example is a very simple "Hello World" greeting service. It supports GET
 requests for generating a greeting message, and a PUT request for changing the
 greeting itself. The response is encoded using JSON.
For example:</p>

<markup
lang="bash"
title="Try the Application"
>curl -X GET http://localhost:8080/greet
{"message":"Hello World!"}

curl -X GET http://localhost:8080/greet/Joe
{"message":"Hello Joe!"}

curl -X PUT -H "Content-Type: application/json" -d '{"greeting" : "Hola"}' http://localhost:8080/greet/greeting

curl -X GET http://localhost:8080/greet/Jose
{"message":"Hola Jose!"}</markup>

</div>


<h2 id="_health_and_metrics">Health and Metrics</h2>
<div class="section">
<p>Helidon provides built-in support for health and metrics endpoints.</p>

<markup
lang="bash"
title="Health"
>curl -s -X GET http://localhost:8080/health</markup>

<markup
lang="bash"
title="Metrics in Prometheus Format"
>curl -s -X GET http://localhost:8080/metrics</markup>

<markup
lang="bash"
title="Metrics in JSON Format"
>curl -H 'Accept: application/json' -X GET http://localhost:8080/metrics</markup>

</div>


<h2 id="_build_a_docker_image">Build a Docker Image</h2>
<div class="section">
<p>The project also contains a Dockerfile so that you can easily build and run a
 Docker image. To build the Docker image, you need to have Docker installed and
 running on your system.</p>

<markup
lang="bash"
title="Docker build"
>docker build -t helidon-quickstart-mp .</markup>

<markup
lang="bash"
title="Run Docker Image"
>docker run --rm -p 8080:8080 helidon-quickstart-mp:latest</markup>

<p>Then you can try the application as you did before.</p>

</div>


<h2 id="_deploy_the_application_to_kubernetes">Deploy the Application to Kubernetes</h2>
<div class="section">
<p>If you don&#8217;t have access to a Kubernetes cluster, you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.
Then deploy the example:</p>

<markup
lang="bash"
title="Verify connectivity to cluster"
>kubectl cluster-info
kubectl get nodes</markup>

<markup
lang="bash"
title="Deploy the application to Kubernetes"
>kubectl create -f app.yaml
kubectl get pods # Wait for quickstart pod to be RUNNING</markup>

<p>The step above created a service that is exposed into any node port. Lookup
 the service to find the port.</p>

<markup
lang="bash"
title="Lookup the service"
>kubectl get service helidon-quickstart-mp</markup>

<p>Note the PORTs. You can now exercise the application as you did before but use
 the second port number (the NodePort) instead of 8080. For example:</p>

<markup
lang="bash"

>curl -X GET http://localhost:31431/greet</markup>

<p>After you&#8217;re done, cleanup.</p>

<markup
lang="bash"
title="Remove the application from Kubernetes"
>kubectl delete -f app.yaml</markup>

</div>


<h2 id="_building_native_and_custom_runtime_images">Building Native and Custom Runtime Images</h2>
<div class="section">
<p>Helidon also includes support for GraalVM Native Images and Java Custom
Runtime Images. For more information see:</p>

<ul class="ulist">
<li>
<p><router-link to="/mp/guides/graalnative">GraalVM Native Images</router-link></p>

</li>
<li>
<p><router-link to="/mp/guides/jlink-image">Custom Runtime Images using <code>jlink</code></router-link></p>

</li>
</ul>

</div>


<h2 id="_the_helidon_cli">The Helidon CLI</h2>
<div class="section">
<p>With the Helidon CLI you can create additional types of Helidon applications and
use the "dev loop" to do fast, iterative development. <router-link to="/about/cli">Try it now</router-link>.</p>

</div>

</doc-view>
