<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#config-intro" @click.native="this.scrollFix('#config-intro')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MP metrics implements the MicroProfile Metrics specification, providing:</p>

<ul class="ulist">
<li>
<p>a unified way for
MicroProfile
servers to export monitoring data&#8212;&#8203;telemetry&#8212;&#8203;to management agents, and</p>

</li>
<li>
<p>a unified Java API which all application programmers can use to register and update metrics to expose telemetry data from their services.</p>

</li>
<li>
<p>support for metrics-related annotations.</p>

</li>
</ul>

<p>Learn more about the <a target="_blank" href="https://github.com/eclipse/microprofile-metrics/releases/tag/5.0.1">MicroProfile Metrics specification</a>.</p>

<p>Metrics is one of the Helidon observability features.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable metrics
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Adding this dependency packages the full-featured metrics implementation with your service.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_instrumenting_your_service">Instrumenting Your Service</h3>
<div class="section">
<p>You add metrics to your service
in these ways:</p>

<ul class="ulist">
<li>
<p>Annotate bean methods&#8212;&#8203;typically your REST resource endpoint methods (the Java code that receives incoming REST requests); Helidon automatically registers these metrics and updates them when the annotated methods are invoked via CDI.</p>

</li>
<li>
<p>Write code which explicitly invokes the metrics API to register metrics, retrieve previously-registered metrics, and update metric values.</p>

</li>
<li>
<p>Configure some simple <code>REST.request</code> metrics which Helidon automatically registers and updates for all REST resource endpoints.</p>

</li>
</ul>

<p>Later sections of this document describe how to do
each of these.</p>

</div>


<h3 id="_categorizing_types_of_metrics">Categorizing Types of Metrics</h3>
<div class="section">
<p>Helidon distinguishes among <em>scopes</em>, or types, of
metrics as described in the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/microprofile-metrics-spec-5.0.1.html">MP metrics specification</a>.</p>

<p>Helidon includes metrics in the built-in scopes described below.
Applications often register their own metrics in the <code>application</code> scope but can create their own scopes and register metrics within them.</p>

<div class="block-title"><span>Built-in metric scopes</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Built-in Scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>base</code></td>
<td class="">OS or Java runtime measurements (available heap, disk space, etc.).
Mandated by the MP metrics specification</td>
</tr>
<tr>
<td class=""><code>vendor</code></td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements (described in later sections).</td>
</tr>
<tr>
<td class=""><code>application</code></td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When you add metrics annotations to your service code, Helidon registers the resulting metrics in the  <code>application</code> scope.</p>

</div>


<h3 id="_metric_registries">Metric Registries</h3>
<div class="section">
<p>A <em>metric registry</em> collects registered metrics of a given scope. Helidon supports one metrics registry for each scope.</p>

<p>When you add code to your service to create a metric programmatically, the code first locates the appropriate registry and then registers the metric with that registry.</p>

</div>


<h3 id="_retrieving_metrics_reports_from_your_service">Retrieving Metrics Reports from your Service</h3>
<div class="section">
<p>When you add the
metrics dependency
to your project, Helidon automatically provides a built-in REST endpoint <code>/metrics</code> which responds with a report of the registered metrics and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by specifying the scope as a query parameter in the request URL:</p>

<ul class="ulist">
<li>
<p><code>/metrics?scope=base</code></p>

</li>
<li>
<p><code>/metrics?scope=vendor</code></p>

</li>
<li>
<p><code>/metrics?scope=application</code></p>

</li>
</ul>

<p>Further, clients can narrow down to a specific metric name by adding the name as another query parameter, such as <code>/metrics?scope=application&amp;name=myCount</code>.</p>

<markup
lang="bash"
title="Example Reporting: Prometheus format"
>curl -s -H 'Accept: text/plain' -X GET http://localhost:8080/metrics</markup>

<markup
lang="text"

># TYPE base:classloader_total_loaded_class_count counter
# HELP base:classloader_total_loaded_class_count Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
base:classloader_total_loaded_class_count 3157</markup>

<markup
lang="bash"
title="Example Reporting: JSON format"
>curl -s -H 'Accept: application/json' -X GET http://localhost:8080/metrics</markup>

<markup
lang="json"
title="JSON response:"
>{
   "base" : {
      "memory.maxHeap" : 3817865216,
      "memory.committedHeap" : 335544320
    }
}</markup>

<p>In addition to your application metrics, the reports contain other
metrics of interest such as system and VM information.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/package-summary.html">MicroProfile Metrics API</a> prescribes all the standard interfaces related to metrics. This section summarizes a few key points about using that API and explains some Helidon-specific interfaces.</p>


<h3 id="_metrics_annotations">Metrics Annotations</h3>
<div class="section">
<p>You can very easily instrument your service and refer to registered metrics by annotating methods to be measured and injecting metrics which your code needs to observe.</p>


<h4 id="_metric_defining_annotations">Metric-defining Annotations</h4>
<div class="section">
<p>The MicroProfile Metrics specification describes several metric types you can create using annotations, summarized in the following table:</p>

<div class="block-title"><span>Metrics Annotations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/annotation/Counted.html"><code>@Counted</code></a></td>
<td class="">Monotonically increasing count of events.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/annotation/Gauge.html"><code>@Gauge</code></a></td>
<td class="">Access to a value managed by other code in the service.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/annotation/Timed.html"><code>@Timed</code></a></td>
<td class="">Frequency of invocations and the distribution of how long the invocations take.</td>
</tr>
</tbody>
</table>
</div>

<p>Place annotations on constructors or methods to measure those specific executables. If you annotate the class instead, Helidon applies that annotation to all constructors and methods which the class declares.</p>

</div>


<h4 id="_metric_referencing_annotations">Metric-referencing Annotations</h4>
<div class="section">
<p>To get a reference to a specific metric, use a metric-referencing annotation in any bean, including your REST resource classes.</p>

<p>You can <code>@Inject</code> a field of the correct type. Helidon uses the MicroProfile Metrics naming conventions to select which specific metric to inject. Use the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/annotation/Metric.html"><code>@Metric</code></a> annotation to control that selection.</p>

<p>You can also add <code>@Metric</code> on a constructor or method parameter to trigger injection there.</p>

<p>Helidon automatically looks up the metric referenced from any injection site and provides a reference to the metric. Your code then simply invokes methods on the injected metric.</p>

</div>

</div>


<h3 id="_the_metricregistry_api">The <code>MetricRegistry</code> API</h3>
<div class="section">
<p>To register or look up metrics programmatically, your service code uses the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/MetricRegistry.html"><code>MetricRegistry</code></a> instance for the scope of interest: <code>base</code>, <code>vendor</code>, <code>application</code>, or a custom scope.</p>

<p>Either of the following techniques gets a <code>MetricRegistry</code> reference.
Remember that injection works only if the class is a bean so CDI can inject into it.</p>

<ul class="ulist">
<li>
<p><code>@Inject MetricRegistry</code>, optionally using <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/annotation/RegistryScope.html"><code>@RegistryScope</code></a> to indicate the registry scope.</p>
<div><markup
lang="java"
title="Injecting the default <code>MetricRegistry</code> (for the application scope)"
>class Example {

    @Inject
    private MetricRegistry applicationRegistry;
}</markup>

<markup
lang="java"
title="Injecting a non-default <code>MetricRegistry</code>"
>class Example {

    @RegistryScope(scope = "myCustomScope")
    @Inject
    private MetricRegistry myCustomRegistry;
}</markup>
</div>

</li>
<li>
<p>Get a Helidon <a target="_blank" href="/apidocs/io.helidon.microprofile.metrics/io/helidon/microprofile/metrics/RegistryFactory.html"><code>RegistryFactory</code></a> instance and invoke its <code>getRegistry</code> method.</p>
<div><p>Obtain the <code>RegistryFactory</code> using either of the following techniques:</p>

<ul class="ulist">
<li>
<p><code>@Inject RegistryFactory</code>.</p>
<markup
lang="java"
title="Getting the <code>RegistryFactory</code> using injection"
>class InjectExample {

    @Inject
    private RegistryFactory registryFactory;

    private MetricRegistry findRegistry(String scope) {
        return registryFactory.getRegistry(scope);
    }
}</markup>

</li>
<li>
<p>Invoke the static <code>getInstance()</code> method on the <code>RegistryFactory</code> class.</p>
<markup
lang="java"
title="Getting the <code>RegistryFactory</code> programmatically"
>class Example {

    private MetricRegistry findRegistry(String scope) {
        return RegistryFactory.getInstance().getRegistry(scope);
    }
}</markup>

</li>
</ul>
</div>

</li>
</ul>

<p>Once it has a reference to a <code>MetricRegistry</code> your code can use the reference to register new metrics, look up previously-registered metrics, and remove metrics.</p>

</div>


<h3 id="_working_with_metrics_in_cdi_extensions">Working with Metrics in CDI Extensions</h3>
<div class="section">
<p>You can work with metrics inside your own CDI extensions, but be careful to do so at the correct point in the CDI lifecycle.
Configuration can influence how the metrics system behaves, as the <router-link to="#config-intro" @click.native="this.scrollFix('#config-intro')">configuration</router-link> section below explains.
Your code should work with metrics only after the Helidon metrics system has initialized itself using configuration.
One way to accomplish this is to deal with metrics in a method that observes the Helidon <code>RuntimeStart</code> CDI event, which the <router-link to="#extension_example" @click.native="this.scrollFix('#extension_example')">extension example below</router-link> illustrates.</p>

</div>

</div>


<h2 id="config-intro">Configuration</h2>
<div class="section">
<p>To control how the Helidon metrics subsystem behaves, add a <code>metrics</code> section to
your <code>META-INF/microprofile-config.properties</code> file.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe.metrics/io/helidon/webserver/observe/metrics/MetricsObserver.html">io.helidon.webserver.observe.metrics.MetricsObserver</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>metrics</code></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.observe.spi.ObserveProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>app-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Value for the application tag to be added to each meter ID.</p>

<pre>@return application tag value</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>app-tag-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name for the application tag to be added to each meter ID.</p>

<pre>@return application tag name</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether metrics functionality is enabled.</p>

<pre>@return if metrics are configured to be enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>metrics</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-performance-indicators</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_KeyPerformanceIndicatorMetricsConfig">KeyPerformanceIndicatorMetricsConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Key performance indicator metrics settings.</p>

<pre>@return key performance indicator metrics settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>permit-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow anybody to access the endpoint.</p>

<pre>@return whether to permit access to metrics endpoint to anybody, defaults to `true`
@see #roles()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>rest-request-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether automatic REST request metrics should be measured.</p>

<pre>@return true/false</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Hints for role names the user is expected to be in.</p>

<pre>@return list of hints</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scoping</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_ScopingConfig">ScopingConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Settings related to scoping management.</p>

<pre>@return scoping settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_Tag">Tag[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Global tags.</p>

<pre>@return name/value pairs for global tags</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon MP includes a pre-written example application illustrating
<a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/metrics/filtering/mp">enabling/disabling metrics</a> using configuration.</p>

<p>The rest of this section contains other examples of working with metrics:</p>

<ul class="ulist">
<li>
<p><router-link to="#example-application-code" @click.native="this.scrollFix('#example-application-code')">Example Application Code</router-link></p>

</li>
<li>
<p><router-link to="#example-configuration" @click.native="this.scrollFix('#example-configuration')">Example Configuration</router-link></p>

</li>
</ul>


<h3 id="example-application-code">Example Application Code</h3>
<div class="section">

<h4 id="_adding_method_level_annotations">Adding Method-level Annotations</h4>
<div class="section">
<p>The following example adds a new resource class, <code>GreetingCards</code>, to the Helidon MP QuickStart example. It shows how to use the <code>@Counted</code> annotation to track the number of times
the <code>/cards</code> endpoint is called.</p>

<markup
lang="java"
title="Create a new class <code>GreetingCards</code> with the following code:"
>@Path("/cards") <span class="conum" data-value="1" />
@RequestScoped <span class="conum" data-value="2" />
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "any-card")  <span class="conum" data-value="3" />
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">This class is annotated with <code>Path</code> which sets the path for this resource
as <code>/cards</code>.</li>
<li data-value="2">The <code>@RequestScoped</code> annotation defines that this bean is
request scoped.  The request scope is active only for the duration of
one web service invocation, and it is destroyed at the end of that
invocation.</li>
<li data-value="3">The annotation <code>@Counted</code> will register a <code>Counter</code> metric for this method, creating it if needed.
The counter is incremented each time the anyCards method is called.  The <code>name</code> attribute is optional.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response:"
>{
  "io.helidon.examples.quickstart.mp.GreetingCards.any-card": 2, //  <span class="conum" data-value="1" />
  "personalizedGets": 0,
  "allGets": {
    "count": 0,
    "elapsedTime": 0,
    "max": 0,
    "mean": 0
  }
}</markup>

<ul class="colist">
<li data-value="1">The any-card count is two, since you invoked the endpoint twice. The other metrics are from the <code>SimpleGreetResource</code> class.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Notice the counter name is fully qualified with the class and method names.  You can remove the prefix by using the <code>absolute=true</code> field in the <code>@Counted</code> annotation.
You must use  <code>absolute=false</code> (the default) for class-level annotations.</p>
</div>

</div>


<h4 id="_additional_method_level_metrics">Additional Method-level Metrics</h4>
<div class="section">
<p>You can also use the @Timed` annotation with a method.  For the following example.
you can just annotate the same method with <code>@Timed</code>. Timers  significant
information about the measured methods, but at a cost of some overhead and more complicated output.</p>

<p>Note that when using multiple annotations on a method, you <strong>must</strong> give the metrics different names as shown below, although they do not have to be absolute.</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "cardCount", absolute = true) <span class="conum" data-value="1" />
    @Timed(name = "cardTimer", absolute = true, unit = MetricUnits.MILLISECONDS) <span class="conum" data-value="2" />
    public JsonObject anyCard() {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">Specify a custom name for the <code>Counter</code> metric and set <code>absolute=true</code> to remove the path prefix from the name.
&lt;2&gt;Add the <code>@Timed</code> annotation to get a <code>Timer</code> metric.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "cardTimer": {
    "count": 2,
    "elapsedTime": 0.002941925,
    "max": 0.002919973,
    "mean": 0.0014709625
  },
  "personalizedGets": 0,
  "allGets": {
    "count": 0,
    "elapsedTime": 0,
    "max": 0,
    "mean": 0
  },
  "cardCount": 2
}</markup>

</div>


<h4 id="_class_level_metrics">Class-level Metrics</h4>
<div class="section">
<p>You can collect metrics at the class level to aggregate data from all methods in that class using the same metric.
The following example introduces a metric to count all card queries.  In the following example, the method-level metrics are not
needed to aggregate the counts, but they are left in the example to demonstrate the combined output of all three metrics.</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
@Counted(name = "totalCards") <span class="conum" data-value="1" />
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true) <span class="conum" data-value="2" />
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    @Path("/birthday")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true) <span class="conum" data-value="3" />
    public JsonObject birthdayCard() throws InterruptedException {
        return createResponse("Here are some birthday cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">This class is now annotated with <code>@Counted</code>, which aggregates count data from all the method that have a <code>Count</code> annotation.</li>
<li data-value="2">Use <code>absolute=true</code> to remove path prefix for method-level annotations.</li>
<li data-value="3">Add a method with a <code>Counter</code> metric to get birthday cards.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response from <code>/metrics?scope=application</code>:"
>{
  "birthdayCard": 1,
  "personalizedGets": 0,
  "allGets": {
    "count": 0,
    "elapsedTime": 0,
    "max": 0,
    "mean": 0
  },
  "anyCard": 1,
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 2 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The <code>totalCards.GreetingCards</code> count is a total of all the method-level <code>Counter</code> metrics.  Class level metric names are always
fully qualified.</li>
</ul>

</div>


<h4 id="_field_level_metrics">Field Level Metrics</h4>
<div class="section">
<p>Field level metrics can be injected into managed objects, but they need to be updated by the application code.
This annotation can be used on fields of type <code>Timer</code>, <code>Counter</code>, and <code>Histogram</code>.</p>

<p>The following example shows how to use a field-level <code>Counter</code> metric to track cache hits.</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
@Counted(name = "totalCards")
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @Inject
    @Metric(name = "cacheHits", absolute = true) <span class="conum" data-value="1" />
    private Counter cacheHits;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true)
    public JsonObject anyCard() throws InterruptedException {
        updateStats(); <span class="conum" data-value="2" />
        return createResponse("Here are some random cards ...");
    }

    @Path("/birthday")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true)
    public JsonObject birthdayCard() throws InterruptedException {
        updateStats();  <span class="conum" data-value="3" />
        return createResponse("Here are some birthday cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }

    private void updateStats() {
        if (new Random().nextInt(3) == 1) {
            cacheHits.inc(); <span class="conum" data-value="4" />
        }
    }
}</markup>

<ul class="colist">
<li data-value="1">A <code>Counter</code> metric field, <code>cacheHits</code>, is automatically injected by Helidon.</li>
<li data-value="2">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="3">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="4">Randomly increment the <code>cacheHits</code> counter.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the following endpoints:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response from <code>/metrics/application</code>:"
>{
  "birthdayCard": 3,
  "personalizedGets": 0,
  "allGets": {
    "count": 0,
    "elapsedTime": 0,
    "max": 0,
    "mean": 0
  },
  "anyCard": 2,
  "cacheHits": 2, <span class="conum" data-value="1" />
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 5
}</markup>

<ul class="colist">
<li data-value="1">The cache was hit two times out of five queries.</li>
</ul>

</div>


<h4 id="_gauge_metric">Gauge Metric</h4>
<div class="section">
<p>The metrics you have tested so far are updated in response to an application REST request, i.e. GET <code>/cards</code>.  These
metrics can be declared in a request scoped class and Helidon will store the metric in the <code>MetricRegistry</code>, so the value persists
across requests. When GET <code>/metrics?scope=application</code> is invoked, Helidon will return the current value of the metric stored in the <code>MetricRegistry</code>.</p>

<p>The <code>Gauge</code> annotation is different from the other metric annotations. The application must provide a method to return the gauge value in an
application-scoped class. When GET <code>/metrics?scope=application</code> is invoked, Helidon will call the <code>Gauge</code> method, using the returned value as the value of the gauge as part of the metrics response.</p>

<p>The following example demonstrates how to use a <code>Gauge</code> to track application up-time.</p>

<markup
lang="java"
title="Create a new <code>GreetingCardsAppMetrics</code> class with the following code:"
>@ApplicationScoped <span class="conum" data-value="1" />
public class GreetingCardsAppMetrics {

    private AtomicLong startTime = new AtomicLong(0); <span class="conum" data-value="2" />

    public void onStartUp(@Observes @Initialized(ApplicationScoped.class) Object init) {
        startTime = new AtomicLong(System.currentTimeMillis()); <span class="conum" data-value="3" />
    }

    @Gauge(unit = "TimeSeconds")
    public long appUpTimeSeconds() {
        return Duration.ofMillis(System.currentTimeMillis() - startTime.get()).getSeconds();  <span class="conum" data-value="4" />
    }
}</markup>

<ul class="colist">
<li data-value="1">This managed object must be application scoped to properly register and use the annotated <code>Gauge</code> metric.</li>
<li data-value="2">Declare an <code>AtomicLong</code> field to hold the start time of the application.</li>
<li data-value="3">Initialize the application start time.</li>
<li data-value="4">Return the application <code>appUpTimeSeconds</code> metric, which will be included in the application metrics.</li>
</ul>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code to simplify the metrics output:"
>@Path("/cards")
@RequestScoped
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "cardCount", absolute = true)
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<markup
lang="bash"
title="Build and run the application, then invoke the application metrics endpoint:"
>curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response from <code>/metrics/application</code>:"
>{
  "personalizedGets": 0,
  "allGets": {
    "count": 0,
    "elapsedTime": 0,
    "max": 0,
    "mean": 0
  },
  "io.helidon.examples.quickstart.mp.GreetingCardsAppMetrics.appUpTimeSeconds": 23, <span class="conum" data-value="1" />
  "cardCount": 0
}</markup>

<ul class="colist">
<li data-value="1">The application has been running for 23 seconds.</li>
</ul>

</div>


<h4 id="extension_example">Working with Metrics in CDI Extensions</h4>
<div class="section">
<p>You can work with metrics from your own CDI extension by observing the <code>RuntimeStart</code> event.</p>

<markup
lang="java"
title="CDI Extension that works correctly with metrics"
>public class MyExtension implements Extension {
    void startup(@Observes @RuntimeStart Object event,  <span class="conum" data-value="1" />
                 MetricRegistry metricRegistry) {       <span class="conum" data-value="2" />
        metricRegistry.counter("myCounter");         <span class="conum" data-value="3" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Declares that your observer method responds to the <code>RuntimeStart</code> event. By this time, Helidon has initialized the metrics system.</li>
<li data-value="2">Injects a <code>MetricRegistry</code> (the application registry by default).</li>
<li data-value="3">Uses the injected registry to register a metric (a counter in this case).</li>
</ul>

<v-card flat color="grey lighten-3"  class="card__example">
<v-card-text><p>Helidon does not prevent you from working with metrics earlier than the <code>RuntimeStart</code> event, but, if you do so, then Helidon might ignore certain configuration settings that would otherwise control how metrics behaves.
Instead, consider writing your extension to use earlier lifecycle events (such as <code>ProcessAnnotatedType</code>) to gather and store information about metrics that you want to register.
Then your extension&#8217;s <code>RuntimeStart</code> observer method would use that stored information to register the metrics you need.</p>
</v-card-text>
</v-card>


</div>

</div>


<h3 id="example-configuration">Example Configuration</h3>
<div class="section">
<p>Metrics configuration is quite extensive and powerful and, therefore, a bit complicated.
The rest of this section illustrates some of the most common scenarios:</p>

<ul class="ulist">
<li>
<p><router-link to="#config-disable" @click.native="this.scrollFix('#config-disable')">Disable metrics entirely.</router-link></p>

</li>
<li>
<p><router-link to="#config-kpi" @click.native="this.scrollFix('#config-kpi')">Choose whether to collect extended key performance indicator metrics.</router-link></p>

</li>
<li>
<p><router-link to="#config-rest-request" @click.native="this.scrollFix('#config-rest-request')">Control <code>REST.request</code> metrics collection.</router-link></p>

</li>
</ul>


<h4 id="config-disable">Disable Metrics Subsystem</h4>
<div class="section">
<markup
lang="properties"
title="Disabling metrics entirely"
>metrics.enabled=false</markup>

<p>Helidon does not update metrics, and the <code>/metrics</code> endpoints respond with <code>404</code>..</p>

</div>


<h4 id="config-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Metrics</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks a basic performance indicator metric: a <code>Counter</code> of all requests received (<code>requests.count</code>)</p>

<p>Helidon MP also includes additional, extended KPI metrics which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>Gauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Counter</code> (<code>requests.longRunning</code>) measuring the total number of requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Counter</code> (<code>requests.load</code>) measuring the number of requests worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Gauge</code> (<code>requests.deferred</code>) measuring delayed request processing (work on a request was delayed after Helidon received the request)</p>

</li>
</ul>

<p>You can enable and control these metrics using configuration:</p>

<markup
lang="properties"
title="Controlling extended KPI metrics"
>metrics.key-performance-indicators.extended = true
metrics.key-performance-indicators.long-running.threshold-ms = 2000</markup>

</div>


<h4 id="config-rest-request">Enable <code>REST.request</code> Metrics</h4>
<div class="section">
<markup
lang="properties"
title="Controlling REST request metrics"
>metrics.rest-request-enabled=true</markup>

<p>Helidon automatically registers and updates <code>Timer</code> metrics for every REST endpoint in your service.</p>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_integration_with_kubernetes_and_prometheus">Integration with Kubernetes and Prometheus</h3>
<div class="section">

<h4 id="_kubernetes_integration">Kubernetes Integration</h4>
<div class="section">
<p>The following example shows how to integrate the Helidon MP application with Kubernetes.</p>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-metrics-mp .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>metrics.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-metrics <span class="conum" data-value="1" />
  labels:
    app: helidon-metrics
  annotations:
    prometheus.io/scrape: "true" <span class="conum" data-value="2" />
spec:
  type: NodePort
  selector:
    app: helidon-metrics
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-metrics
spec:
  replicas: 1 <span class="conum" data-value="3" />
  selector:
    matchLabels:
      app: helidon-metrics
  template:
    metadata:
      labels:
        app: helidon-metrics
        version: v1
    spec:
      containers:
        - name: helidon-metrics
          image: helidon-metrics-mp
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">An annotation that will allow Prometheus to discover and scrape the application pod.</li>
<li data-value="3">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./metrics.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-metrics</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-metrics   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the metrics endpoint using port <code>30116</code>, your port will likely be different:"
>curl http://localhost:31143/metrics</markup>

<div class="admonition note">
<p class="admonition-inline">Leave the application running in Kubernetes since it will be used for Prometheus integration.</p>
</div>

</div>


<h4 id="_prometheus_integration">Prometheus Integration</h4>
<div class="section">
<p>The metrics service that you just deployed into Kubernetes is already annotated with <code>prometheus.io/scrape:</code>.  This will allow
Prometheus to discover the service and scrape the metrics.  This example shows how to install Prometheus
into Kubernetes, then verify that it discovered the Helidon metrics in your application.</p>

<markup
lang="bash"
title="Install Prometheus and wait until the pod is ready:"
>helm install stable/prometheus --name metrics
export POD_NAME=$(kubectl get pods --namespace default -l "app=prometheus,component=server" -o jsonpath="{.items[0].metadata.name}")
kubectl get pod $POD_NAME</markup>

<p>You will see output similar to the following.  Repeat the <code>kubectl get pod</code> command until you see <code>2/2</code> and <code>Running</code>. This may take up to one minute.</p>

<markup
lang="bash"

>metrics-prometheus-server-5fc5dc86cb-79lk4   2/2     Running   0          46s</markup>

<markup
lang="bash"
title="Create a port-forward, so you can access the server URL:"
>kubectl --namespace default port-forward $POD_NAME 7090:9090</markup>

<p>Now open your browser and navigate to <code><a target="_blank" href="http://localhost:7090/targets" class="bare">http://localhost:7090/targets</a></code>.  Search for helidon on the page, and you will see your
Helidon application as one of the Prometheus targets.</p>

</div>


<h4 id="_final_cleanup">Final Cleanup</h4>
<div class="section">
<p>You can now delete the Kubernetes resources that were just created during this example.</p>

<markup
lang="bash"
title="Delete the Prometheus Kubernetes resources:"
>helm delete --purge metrics</markup>

<markup
lang="bash"
title="Delete the application Kubernetes resources:"
>kubectl delete -f ./metrics.yaml</markup>

</div>

</div>


<h3 id="_references">References</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/microprofile-metrics-spec-5.0.1.html">MicroProfile Metrics specification</a></p>

<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs/org/eclipse/microprofile/metrics/package-summary.html">MicroProfile Metrics API</a></p>

</div>

</div>

</doc-view>
