<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MP simplifies how you can use Micrometer for application-specific metrics:</p>

<ul class="ulist">
<li>
<p>The endpoint <code>/micrometer</code>: A configurable endpoint that exposes metrics according to which Micrometer meter registry
responds to the HTTP request.</p>

</li>
<li>
<p>The Micrometer annotations <code>@Timed</code> and <code>@Counted</code>.</p>

</li>
<li>
<p>Configuration to tailor the Prometheus and other Micrometer meter registries.</p>

</li>
</ul>

<p>In Helidon 4.0.8, Micrometer support is separate from the Helidon MP metrics API and the built-in Helidon metrics.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Micrometer support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.micrometer&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-micrometer-cdi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Micrometer supports different types of meter registries which have different output styles and formats.
Helidon provides built-in support for the Prometheus meter registry.
To use other meter registry types, you will need to add dependencies for them to your <code>pom.xml</code> and, optionally, add
configuration to set them up as you wish.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Your application registers and updates Micrometer meters using annotations or direct use of the Micrometer API.</p>

<p>Your users retrieve Micrometer meters using an endpoint which Helidon creates automatically.</p>


<h3 id="_registering_and_updating_meters">Registering and Updating Meters</h3>
<div class="section">
<p>To use Micrometer support, you can simply add the Micrometer <code>@Timed</code> and <code>@Counted</code> annotations to methods in your application. Helidon automatically registers those meters with the Micrometer composite <code>MeterRegistry</code>.</p>

<p>In addition to annotating your methods, your code
can create, look up, and update metrics programmatically using the Micrometer <code>MeterRegistry</code> API. The <a target="_blank" href="https://docs.micrometer.io/micrometer/reference/concepts.html">Micrometer concepts document</a> provides a good starting point for learning how to use Micrometer&#8217;s interfaces and classes.</p>

</div>


<h3 id="_accessing_the_helidon_micrometer_endpoint">Accessing the Helidon Micrometer Endpoint</h3>
<div class="section">
<p>Helidon MP Micrometer integration automatically creates
a REST endpoint which clients can access to retrieve Micrometer metrics, by default at the <code>/micrometer</code> endpoint.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>To incorporate Micrometer metrics into your code, you will work with two APIs: a small one specific to Helidon, and the Micrometer API itself.</p>


<h3 id="_the_helidon_micrometer_api">The Helidon Micrometer API</h3>
<div class="section">
<p>Helidon automatically registers and updates meters associated with methods in your service where you add the Micrometer annotations.</p>

<p>If you want to use the Micrometer <code>MeterRegistry</code> directly from your own code, simply <code>@Inject</code> the <code>MeterRegistry</code> into one of your REST resource classes or any other bean which CDI recognizes. Helidon injects the same Micrometer <code>MeterRegistry</code> that it uses for handling Micrometer annotations you add to your code.</p>

</div>


<h3 id="_the_micrometer_api">The Micrometer API</h3>
<div class="section">
<p>Your code
can create, look up, and update metrics programmatically using the Micrometer <code>MeterRegistry</code> API. The <a target="_blank" href="https://docs.micrometer.io/micrometer/reference/concepts.html">Micrometer concepts document</a> provides a good starting point for learning how to use Micrometer&#8217;s interfaces and classes.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can configure the Helidon Micrometer REST service as you can other built-in Helidon services by adding configuration settings under the <code>micrometer</code> top-level key.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.integrations.micrometer/io/helidon/integrations/micrometer/MicrometerFeature.html">io.helidon.integrations.micrometer.MicrometerFeature</a></p>

<markup
lang="text"
title="Config key"
>micrometer</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cross-origin-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the CORS config from the specified <code>CrossOriginConfig</code> object.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the root context for the REST API of the service.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>By default, Helidon Micrometer integration exposes the <code>/micrometer</code> endpoint.
You can override the path using
the <code>micrometer.web-context</code> configuration key.</p>

<markup
lang="properties"
title="Overriding the default Micrometer path"
>micrometer.web-context=my-micrometer</markup>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon MP includes an <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/integrations/micrometer/mp">example application</a> which uses Micrometer support.</p>

<p>The examples below take you step-by-step through the process of enhancing the Helidon MP QuickStart application to track (by time and invocation count) all <code>GET</code> methods and to count all requests for a personalized greeting.</p>


<h3 id="_add_micrometer_annotations">Add Micrometer annotations</h3>
<div class="section">
<markup
lang="java"
title="Adding Micrometer annotations to JAX-RS resource <code>GET</code> methods"
>private static final String PERSONALIZED_GETS_COUNTER_NAME = "personalizedGets";
private static final String PERSONALIZED_GETS_COUNTER_DESCRIPTION = "Counts personalized GET operations";
private static final String GETS_TIMER_NAME = "allGets";
private static final String GETS_TIMER_DESCRIPTION = "Tracks all GET operations";

@GET
@Produces(MediaType.APPLICATION_JSON)
@Timed(value = GETS_TIMER_NAME, description = GETS_TIMER_DESCRIPTION, histogram = true) <span class="conum" data-value="1" />
public JsonObject getDefaultMessage() {
    return createResponse("World");
}

@Path("/{name}")
@GET
@Produces(MediaType.APPLICATION_JSON)
@Counted(value = PERSONALIZED_GETS_COUNTER_NAME, description = PERSONALIZED_GETS_COUNTER_DESCRIPTION) <span class="conum" data-value="2" />
@Timed(value = GETS_TIMER_NAME, description = GETS_TIMER_DESCRIPTION, histogram = true) <span class="conum" data-value="1" />
public JsonObject getMessage(@PathParam("name") String name) {
    return createResponse(name);
}</markup>

<ul class="colist">
<li data-value="1">Use <code>@Timed</code> to time and count both <code>GET</code> methods.</li>
<li data-value="2">Use <code>@Counted</code> to count the accesses to the <code>GET</code> method that returns a personalized greeting.</li>
</ul>

</div>


<h3 id="_using_the_helidon_provided_micrometer_meterregistry_from_code">Using the Helidon-provided Micrometer <code>MeterRegistry</code> from Code</h3>
<div class="section">
<p>In addition to annotating your methods, you can create, look up, and update metrics explicitly in your code.</p>

<p>Add the following injection to a bean:</p>

<markup
lang="java"
title="Inject the <code>MeterRegistry</code>"
>@Inject
private MeterRegistry registry;</markup>

<p>Helidon automatically injects a reference to the <code>MeterRegistry</code> it manages into your code. Your code can use the
 normal Micrometer API with this registry to create, find, update, and even delete meters.</p>


<h4 id="_overriding_defaults_for_built_in_meter_registry_types">Overriding Defaults for Built-in Meter Registry Types</h4>
<div class="section">
<p>Unless you specify otherwise, Helidon uses defaults for any built-in Micrometer meter registry.
For example, Helidon configures the built-in Prometheus registry using <code>PrometheusConfig.DEFAULT</code>.</p>

<p>To use configuration to control the selection and behavior of Helidon&#8217;s built-in Micrometer meter registries,
include in your configuration (such as <code>application.yaml</code>) a <code>micrometer.builtin-registries</code> section.</p>

<markup
lang="properties"
title="Enroll Prometheus built-in meter registry using default configuration"
>micrometer.builtin-registries.0.type=prometheus</markup>

<markup
lang="properties"
title="Enroll Prometheus built-in meter registry with non-default configuration"
>micrometer.builtin-registries.0.type=prometheus
micrometer.builtin-registries.0.prefix=myPrefix</markup>

<p>Note that the first config example is equivalent to the default Helidon Micrometer behavior; Helidon by default supports the Prometheus meter registry.</p>

<p>The configuration keys that are valid for the <code>builtin-registries</code> child entries depend on the type of Micrometer meter
registry.
For example, support in Helidon for the <a target="_blank" href="https://javadoc.io/doc/io.micrometer/micrometer-registry-prometheus/1.11.1/io/micrometer/prometheus/PrometheusConfig.html">Prometheus meter registry</a> respects the <code>prefix</code> configuration setting but other meter registries might not and might support other settings.
Refer to the documentation for the meter registry you want to configure to find out what items apply to that registry
type.</p>

<p>Helidon does not validate the configuration keys you specify for
meter registries.</p>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The <a target="_blank" href="https://micrometer.io">Micrometer website</a> describes the project as a whole and has links to more information.</p>

</div>

</doc-view>
