<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>In Helidon 4 all observability features were moved to one logical module: <code>observe</code>. Observability features specified by MicroProfile&#8212;&#8203;such as metrics and health&#8212;&#8203;keep their familiar endpoints. The endpoints for other observability features are grouped together under a single context root which defaults to <code>/observe</code>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>You do not need to explicitly add any observability dependency in your Helidon MP project <code>pom.xml</code> file for MicroProfile technologies.
Adding a dependency on Helidon&#8217;s MP metrics or health component, for example, brings along the necessary observability components automatically.</p>

<p>To include other observability features in your Helidon MP application, add one or more of the following dependencies.</p>

<p>For Info Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-info&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Logging Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Configuration Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-config&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The MicroProfile observability features use top-level endpoints (such as <code>/health</code> and <code>/metrics</code>) which you can customize if you wish. See the <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link> section below for more information.</p>

<p>Other observability features add endpoints under the <code>/observe</code> path</p>


<h3 id="_feature_weight_and_endpoint_conflicts">Feature Weight and Endpoint Conflicts</h3>
<div class="section">
<p>In some ways Helidon treats all types of observers as a single observability <em>feature</em>.
In particular, you can use configuration to control the <em>weight</em> of the various Helidon features, and the weight prescribes the order in which Helidon handles routing for those features.</p>

<p>The Helidon-provided feature for processing your application endpoints has weight 100 by default, and the observability feature has default weight 80.
This means that Helidon normally prioritizes routing for your application endpoints over the endpoints for the observers such as metrics and health.</p>

<p>This can have unexpected results if your application declares a resource path <code>/{name}</code>. Because Helidon normally prioritizes the routing of <em>your</em> endpoints, Helidon routes requests for <code>/metrics</code> and <code>/health</code> to <em>your</em> <code>/{name}</code> endpoint instead of to the actual metrics and health endpoints.</p>

<p>One way to avoid this is to assign a weight from 101 to 200 to the observe feature in your configuration. Then Helidon prioritizes the routing of the observe feature ahead of routing your application endpoints.</p>

<markup
lang="properties"
title="Configuration in <code>META-INF/microprofile-config.properties</code> Assigning Feature Weight to Control Routing"
>server.features.observe.weight = 120</markup>

<p>Helidon does not enforce the weight range 101-200 for observability, but you should use a value in this range for the observe weight to avoid problems with other features such as security, CORS, and others; their relative ordering is important.</p>

</div>


<h3 id="_endpoints">Endpoints</h3>
<div class="section">
<p>Some observer endpoints&#8212;&#8203;metrics and health&#8212;&#8203;were present in earlier releases of Helidon MP. By default those continue to use their customary paths (<code>/metrics</code>, <code>/health</code>). You can customize the endpoint for each of those observers are described in the documentation for each observer.</p>

<p>Other observers have no counterpart in the MicroProfile spec and they respond by default at subpaths of <code>/observe</code> as described below.</p>


<h4 id="_configuration_observability">Configuration Observability</h4>
<div class="section">
<p>Configuration observability allows reading the current application configuration values.
Configuration observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/config/profile</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the current configuration profile</td>
</tr>
<tr>
<td class=""><code>/config/values</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the current configuration values</td>
</tr>
<tr>
<td class=""><code>/config/values/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns specified by <code>name</code> configuration value</td>
</tr>
</tbody>
</table>
</div>

<div class="admonition note">
<p class="admonition-inline">All secrets and passwords are obfuscated with "*" characters.</p>
</div>

</div>


<h4 id="_health_observability">Health Observability</h4>
<div class="section">
<p>Health observability allows reading application readiness to serve requests, whether the services are alive.
Health observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/health/ready</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns Service Readiness</td>
</tr>
<tr>
<td class=""><code>/health/live</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service is alive</td>
</tr>
<tr>
<td class=""><code>/health/started</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service is started</td>
</tr>
<tr>
<td class=""><code>/health/ready/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns Service <code>name</code> Readiness</td>
</tr>
<tr>
<td class=""><code>/health/live/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service <code>name</code> is alive</td>
</tr>
<tr>
<td class=""><code>/health/started/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service <code>name</code> is started</td>
</tr>
<tr>
<td class=""><code>/health/check/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns all checks for service <code>name</code></td>
</tr>
<tr>
<td class=""><code>/health/ready</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns Service Readiness without details</td>
</tr>
<tr>
<td class=""><code>/health/live</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service is alive without details</td>
</tr>
<tr>
<td class=""><code>/health/started</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service is started without details</td>
</tr>
<tr>
<td class=""><code>/health/ready/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns Service <code>name</code> Readiness without details</td>
</tr>
<tr>
<td class=""><code>/health/live/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service <code>name</code> is alive without details</td>
</tr>
<tr>
<td class=""><code>/health/started/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service <code>name</code> is started without details</td>
</tr>
<tr>
<td class=""><code>/health/check/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns all checks for service <code>name</code> without details</td>
</tr>
</tbody>
</table>
</div>

<p>For more information, please, check <router-link to="/se/health">Health</router-link> documentation.</p>

</div>


<h4 id="_information_observability">Information Observability</h4>
<div class="section">
<p>Info observability allows configuration of custom properties to be available to users.
Information observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/info</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Application information</td>
</tr>
<tr>
<td class=""><code>/info/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Application information for the specified <code>name</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_logger_observability">Logger Observability</h4>
<div class="section">
<p>Log observability allows reading and configuring of log levels of various loggers and reading log messages.
Logger Observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/log</code></td>
<td class=""><code>GET</code></td>
<td class="">Stream logs (if enabled)</td>
</tr>
<tr>
<td class=""><code>/log/loggers</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns all logger handlers</td>
</tr>
<tr>
<td class=""><code>/log/log/loggers/{logger}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Logger by name <code>logger</code></td>
</tr>
<tr>
<td class=""><code>/log/loggers/{logger}</code></td>
<td class=""><code>POST</code></td>
<td class="">Set Logger level by name <code>logger</code></td>
</tr>
<tr>
<td class=""><code>/log/loggers/{logger}</code></td>
<td class=""><code>DELETE</code></td>
<td class="">Unset the specified logger <code>logger</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_metrics_observability">Metrics Observability</h4>
<div class="section">
<p>Helidon distinguishes among three general <em>types</em>, or scopes, of metrics.</p>

<div class="block-title"><span>Types (scopes) of metrics</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Type/scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">base</td>
<td class="">OS or Java runtime measurements (available heap, disk space, etc.).</td>
</tr>
<tr>
<td class="">vendor</td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements.</td>
</tr>
<tr>
<td class="">application</td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When you add the metrics dependency to your project, Helidon automatically provides a built-in REST endpoint <code>/observe/metrics</code> which responds with a report of the registered metrics and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/observe/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by appending the metric type to the path:</p>

<ul class="ulist">
<li>
<p><code>/observe/metrics/base</code></p>

</li>
<li>
<p><code>/observe/metrics/vendor</code></p>

</li>
<li>
<p><code>/observe/metrics/application</code></p>

</li>
</ul>

<p>For more information see <router-link to="/se/metrics/metrics">Metrics</router-link> documentation.</p>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To customize the endpoint of an observer:</p>

<ol style="margin-left: 15px;">
<li>
For MicroProfile technologies (metrics, health) refer to the Helidon MP documentation for them:
<ul class="ulist">
<li>
<p><router-link :to="{path: '/mp/metrics/metrics', hash: '#config-intro'}">metrics config</router-link> documentation</p>

</li>
<li>
<p><router-link :to="{path: '/mp/health', hash: '#_configuration'}">health config</router-link> documentation</p>

</li>
</ul>

</li>
<li>
For other observers, assign a custom endpoint using a config setting such as <code>server.features.observe.info.endpoint</code>.

</li>
</ol>

<p>To control the observability features as a whole, add config settings under <code>server.features.observe</code>.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe/io/helidon/webserver/observe/ObserveFeature.html">io.helidon.webserver.observe.ObserveFeature</a></p>

<markup
lang="text"
title="Config key"
>observe</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class=""><code>@io.helidon.cors.CrossOriginConfig@.create()</code></td>
<td class=""><doc-view>
<p>Cors support inherited by each observe provider, unless explicitly configured.</p>

<pre>@return cors support to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether the observe support is enabled.</p>

<pre>@return `false` to disable observe feature</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/observe</code></td>
<td class=""><doc-view>
<p>Root endpoint to use for observe providers. By default, all observe endpoint are under this root endpoint.</p>

<pre>Example:
&lt;br&gt;
If root endpoint is `/observe` (the default), and default health endpoint is `health` (relative),
health endpoint would be `/observe/health`.</pre>
<pre>@return endpoint to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>observers</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.observe.spi.Observer[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_webserver_observe_config_ConfigObserver">ConfigObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_info_InfoObserver">InfoObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_log_LogObserver">LogObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_tracing_TracingObserver">TracingObserver</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_metrics_MetricsObserver">metrics (MetricsObserver)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_observe_health_HealthObserver">health (HealthObserver)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Observers to use with this observe features.
 Each observer type is registered only once, unless it uses a custom name (default name is the same as the type).</p>

<pre>@return list of observers to use in this feature</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sockets the observability endpoint should be exposed on. If not defined, defaults to the default socket
 (<code>io.helidon.webserver.WebServer#DEFAULT_SOCKET_NAME</code>.
 Each observer may have its own configuration of sockets that are relevant to it, this only controls the endpoints!</p>

<pre>@return list of sockets to register observe endpoint on</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>80.0</code></td>
<td class=""><doc-view>
<p>Change the weight of this feature. This may change the order of registration of this feature.
 By default, observability weight is <code>ObserveFeature#WEIGHT</code> so it is registered after routing.</p>

<pre>@return weight to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The Observability features are now implemented with <code>HttpFeature</code> and can be registered with <code>HttpRouting.Builder#addFeature(java.util.function.Supplier)</code>. Such a feature encapsulates a set of endpoints, services and/or filters.</p>

<p>Feature is similar to <code>HttpService</code> but gives more freedom in setup.
Main difference is that a feature can add <code>Filter</code> filters and it cannot be  registered on a path (that is left to the discretion of the feature developer).</p>

<ul class="ulist">
<li>
<p>Features are not registered immediately - each feature can define a <code>Weight</code> or implement <code>Weighted</code> to order features according to their weight. Higher weighted features are registered first.</p>

</li>
<li>
<p>This is to allow ordering of features in a meaningful way (e.g. Context should be first, Tracing second, Security third etc).</p>

</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.0/microprofile-metrics-spec-5.0.0.pdf">MicroProfile Metrics Specification</a></p>

</li>
<li>
<p><router-link to="/se/metrics/metrics">Metrics</router-link> documentation.</p>

</li>
<li>
<p><router-link to="/se/health">Health</router-link> documentation.</p>

</li>
</ul>

</div>

</doc-view>
