<doc-view>

<h2 id="_implemented_security_providers">Implemented Security Providers</h2>
<div class="section">
<p>Helidon provides the following security providers for endpoint protection:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 16.667%;">
<col style="width: 8.333%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Provider</th>
<th>Type</th>
<th>Outbound supported</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="#OIDC-Provider" @click.native="this.scrollFix('#OIDC-Provider')">OIDC Provider</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">Open ID Connect supporting JWT, Scopes, Groups and OIDC code flow</td>
</tr>
<tr>
<td class=""><router-link to="#_http_basic_authentication_provider" @click.native="this.scrollFix('#_http_basic_authentication_provider')">HTTP Basic Authentication</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">HTTP Basic Authentication support</td>
</tr>
<tr>
<td class=""><router-link to="#_http_digest_authentication_provider" @click.native="this.scrollFix('#_http_digest_authentication_provider')">HTTP Digest Authentication</router-link></td>
<td class="">Authentication</td>
<td class="">🚫</td>
<td class="">HTTP Digest Authentication support</td>
</tr>
<tr>
<td class=""><router-link to="#_header_authentication_provider" @click.native="this.scrollFix('#_header_authentication_provider')">Header Assertion</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">Asserting a user based on a header value</td>
</tr>
<tr>
<td class=""><router-link to="#_http_signatures_provider" @click.native="this.scrollFix('#_http_signatures_provider')">HTTP Signatures</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">Protecting service to service communication through signatures</td>
</tr>
<tr>
<td class=""><router-link to="#_idcs_role_mapper" @click.native="this.scrollFix('#_idcs_role_mapper')">IDCS Roles</router-link></td>
<td class="">Role Mapping</td>
<td class="">🚫</td>
<td class="">Retrieves roles from IDCS provider for authenticated user</td>
</tr>
<tr>
<td class=""><router-link to="#_abac_provider" @click.native="this.scrollFix('#_abac_provider')">ABAC Authorization</router-link></td>
<td class="">Authorization</td>
<td class="">🚫</td>
<td class="">Attribute based access control authorization policies</td>
</tr>
</tbody>
</table>
</div>

<p>The following providers are no longer evolved:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 16.667%;">
<col style="width: 8.333%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Provider</th>
<th>Type</th>
<th>Outbound supported</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="#_google_login_provider" @click.native="this.scrollFix('#_google_login_provider')">Google Login</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">Authenticates a token from request against Google servers</td>
</tr>
<tr>
<td class=""><router-link to="#_jwt_provider" @click.native="this.scrollFix('#_jwt_provider')">JWT Provider</router-link></td>
<td class="">Authentication</td>
<td class="">✅</td>
<td class="">JWT tokens passed from frontend</td>
</tr>
</tbody>
</table>
</div>


<h3 id="OIDC-Provider">OIDC Provider</h3>
<div class="section">
<p>Open ID Connect security provider.</p>


<h4 id="_setup">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-oidc&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Open ID Connect security provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.oidc/io/helidon/security/providers/oidc/OidcProvider.html">io.helidon.security.providers.oidc.OidcProvider</a></p>

<markup
lang="text"
title="Config key"
>oidc</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorization-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of an authorization endpoint used to redirect users to for logging-in.</p>

<pre>If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
an attempt is made to use #identityUri(URI)/oauth2/v1/authorize.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base-scopes</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>openid</code></td>
<td class=""><doc-view>
<p>Configure base scopes.
 By default, this is <code>DEFAULT_BASE_SCOPES</code>.
 If scope has a qualifier, it must be used here.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>check-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Configure audience claim check.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client ID as generated by OIDC server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client secret as generated by OIDC server.
 Used to authenticate this application with the server when requesting
 JWT based on a code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>30000</code></td>
<td class=""><doc-view>
<p>Timeout of calls using web client.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-domain</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Domain the cookie is valid for.
 Not used by default.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to encrypt token cookie created by this microservice.
 Defaults to <code>false</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-id-token</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt id token cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-refresh-token</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt refresh token cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-tenant-name</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt tenant name cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the encryption configuration available through Security#encrypt(String, byte[]) and
 Security#decrypt(String, String).
 If configured and encryption is enabled for any cookie,
 Security MUST be configured in global or current <code>io.helidon.common.context.Context</code> (this
 is done automatically in Helidon MP).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-password</code></td>
<td class=""><doc-view>
<p>char[]</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Master password for encryption/decryption of cookies. This must be configured to the same value on each microservice
 using the cookie.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-http-only</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When using cookie, if set to true, the HttpOnly attribute will be configured.
 Defaults to <code>OidcCookieHandler.Builder#DEFAULT_HTTP_ONLY</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-max-age-seconds</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>When using cookie, used to set MaxAge attribute of the cookie, defining how long
 the cookie is valid.
 Not used by default.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID</code></td>
<td class=""><doc-view>
<p>Name of the cookie to use.
 Defaults to <code>DEFAULT_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-id-token</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID_2</code></td>
<td class=""><doc-view>
<p>Name of the cookie to use for id token.
 Defaults to `DEFAULT_COOKIE_NAME`_2.</p>

<pre>This cookie is only used when logout is enabled, as otherwise it is not needed.
Content of this cookie is encrypted.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-refresh-token</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID_3</code></td>
<td class=""><doc-view>
<p>The name of the cookie to use for the refresh token.
 Defaults to <code>DEFAULT_REFRESH_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-tenant</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>HELIDON_TENANT</code></td>
<td class=""><doc-view>
<p>The name of the cookie to use for the tenant name.
 Defaults to <code>DEFAULT_TENANT_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/</code></td>
<td class=""><doc-view>
<p>Path the cookie is valid for.
 Defaults to "/".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-same-site</code></td>
<td class=""><doc-view>
<p>SameSite (LAX, STRICT, NONE)</p>

</doc-view>
</td>
<td class=""><code>LAX</code></td>
<td class=""><doc-view>
<p>When using cookie, used to set the SameSite cookie value. Can be
 "Strict" or "Lax".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-secure</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When using cookie, if set to true, the Secure attribute will be configured.
 Defaults to false.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to use cookie to store JWT between requests.
 Defaults to <code>DEFAULT_COOKIE_USE</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Assign cross-origin resource sharing settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>force-https-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Force HTTPS for redirects to identity provider.
 Defaults to <code>false</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>frontend-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Full URI of this application that is visible from user browser.
 Used to redirect request back from identity server after successful login.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>header-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A TokenHandler to
 process header containing a JWT.
 Default is "Authorization" header with a prefix "bearer ".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>header-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to expect JWT in a header field.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>id-token-signature-validation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether id token signature check should be enabled.
 Signature check is enabled by default, and it is highly recommended to not change that.
 Change this setting only when you really know what you are doing, otherwise it could case security issues.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>identity-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of the identity server, base used to retrieve OIDC metadata.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>introspect-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Endpoint to use to validate JWT.
 Either use this or set #signJwk(JwkKeys) or #signJwk(Resource).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>5</code></td>
<td class=""><doc-view>
<p>Configure maximal number of redirects when redirecting to an OIDC provider within a single authentication
 attempt.</p>

<pre>Defaults to `DEFAULT_MAX_REDIRECTS`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata-well-known</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to true, metadata will be loaded from default (well known)
 location, unless it is explicitly defined using oidc-metadata-resource. If set to false, it would not be loaded
 even if oidc-metadata-resource is not defined. In such a case all URIs must be explicitly defined (e.g.
 token-endpoint-uri).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Resource configuration for OIDC Metadata
 containing endpoints to various identity services, as well as information about the identity server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the authentication cannot be verified.
 If set to true, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Allow audience claim to be optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundTarget">OutboundTarget[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add a new target configuration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to propagate identity.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Proxy host to use. When defined, triggers usage of proxy for HTTP requests.
 Setting to empty String has the same meaning as setting to null - disables proxy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>80</code></td>
<td class=""><doc-view>
<p>Proxy port.
 Defaults to <code>DEFAULT_PROXY_PORT</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>http</code></td>
<td class=""><doc-view>
<p>Proxy protocol to use when proxy is used.
 Defaults to <code>DEFAULT_PROXY_PROTOCOL</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-id-token-param-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>id_token</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the JWT id token when parameter is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>accessToken</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the JWT access token when parameter is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-tenant-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h_tenant</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the tenant name when the parameter is used.
 Defaults to #DEFAULT_TENANT_PARAM_NAME.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to use a query parameter to send JWT token from application to this
 server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>By default, the client should redirect to the identity server for the user to log in.
 This behavior can be overridden by setting redirect to false. When token is not present in the request, the client
 will not redirect and just return appropriate error response code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect-attempt-param</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h_ra</code></td>
<td class=""><doc-view>
<p>Configure the parameter used to store the number of attempts in redirect.</p>

<pre>Defaults to `DEFAULT_ATTEMPT_PARAM`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/oidc/redirect</code></td>
<td class=""><doc-view>
<p>URI to register web server component on, used by the OIDC server to
 redirect authorization requests to after a user logs in or approves
 scopes.
 Note that usually the redirect URI configured here must be the
 same one as configured on OIDC server.</p>

<pre>Defaults to `DEFAULT_REDIRECT_URI`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists. By default,
 requests that use the Proxy will have absolute URIs. Set this flag to <code>true</code>
 if the host is unable to accept absolute URIs.
 Defaults to <code>DEFAULT_RELATIVE_URIS</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scope-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of the scope required by this application. This is prefixed to
 the scope name when requesting scopes from the identity server.
 Defaults to empty string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Configure one of the supported types of identity servers.</p>

<pre>If the type does not have an explicit mapping, a warning is logged and the default implementation is used.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A resource pointing to JWK with public keys of signing certificates used
 to validate JWT.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tenants</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_oidc_common_TenantConfig">TenantConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configurations of the tenants</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-auth</code></td>
<td class=""><doc-view>
<p>ClientAuthentication (CLIENT_SECRET_BASIC, CLIENT_SECRET_POST, CLIENT_SECRET_JWT, PRIVATE_KEY_JWT, NONE)</p>

</doc-view>
</td>
<td class=""><code>CLIENT_SECRET_BASIC</code></td>
<td class=""><doc-view>
<p>Type of authentication to use when invoking the token endpoint.
 Current supported options:</p>

<ul class="ulist">
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_BASIC</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_POST</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#NONE</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of a token endpoint used to obtain a JWT based on the authentication
 code.
 If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
 an attempt is made to use #identityUri(URI)/oauth2/v1/token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-signature-validation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether access token signature check should be enabled.
 Signature check is enabled by default, and it is highly recommended to not change that.
 Change this setting only when you really know what you are doing, otherwise it could case security issues.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-jwt-groups</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Claim <code>groups</code> from JWT will be used to automatically add
  groups to current subject (may be used with jakarta.annotation.security.RolesAllowed annotation).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-jwt-with-jwk</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use JWK (a set of keys to validate signatures of JWT) to validate tokens.
 Use this method when you want to use default values for JWK or introspection endpoint URI.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h3 id="_example_code">Example code</h3>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/idcs-login">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
  - oidc:
      client-id: "client-id-of-this-service"
      client-secret: "${CLEAR=changeit}"
      identity-uri: "https://your-tenant.identity-server.com"
      frontend-uri: "http://my-service:8080"
      audience: "http://my-service"
      cors:
        allow-origins: ["https://foo.com", "https://there.com"]
        allow-methods: ["PUT", "DELETE"]
      outbound:
        - name: "internal-services"
          hosts: ["*.example.org"]
          outbound-token:
            header: "X-Internal-Auth"</markup>

</div>


<h3 id="oidc-workflow">How does it work?</h3>
<div class="section">
<p>At Helidon startup, if OIDC provider is configured, the following will happen:</p>

<ol style="margin-left: 15px;">
<li>
<code>client-id</code>, <code>client-secret</code>, and <code>identityUri</code> are validated - these must provide values

</li>
<li>
Unless all resources are configured as local resources, the provider attempts
to contact the <code>oidc-metadata.resource</code> endpoint to retrieve all endpoints

</li>
</ol>

<p>At runtime, depending on configuration&#8230;&#8203;</p>

<p>If a request comes without a token or with insufficient scopes:</p>

<ol style="margin-left: 15px;">
<li>
If <code>redirect</code> is set to <code>true</code> (default), request is redirected to the authorization
endpoint of the identity server. If set to false, <code>401</code> is returned

</li>
<li>
User authenticates against the identity server

</li>
<li>
The identity server redirects back to Helidon service with a code

</li>
<li>
Helidon service contacts the identity server&#8217;s token endpoint, to exchange the code
for a JWT

</li>
<li>
The JWT is stored in a cookie (if cookie support is enabled, which it is by default)

</li>
<li>
Helidon service redirects to original endpoint (on itself)

</li>
</ol>

<p>Helidon obtains a token from request (from cookie, header, or query parameter):</p>

<ol style="margin-left: 15px;">
<li>
Token is parsed as a singed JWT

</li>
<li>
We validate the JWT signature either against local JWK or against the identity server&#8217;s
introspection endpoint depending on configuration

</li>
<li>
We validate the issuer and audience of the token if it matches the configured values

</li>
<li>
A subject is created from the JWT, including scopes from the token

</li>
<li>
We validate that we have sufficient scopes to proceed, and return <code>403</code> if not

</li>
<li>
Handling is returned to security to process other security providers

</li>
</ol>

</div>


<h3 id="tenant-enable">Multiple tenants</h3>
<div class="section">
<p>The OIDC provider also supports multiple tenants. To enable this feature, it is required to do several steps.</p>

<ol style="margin-left: 15px;">
<li>
To enable the default multi-tenant support, add the <code>multi-tenant: true</code> option to the
OIDC provider configuration

</li>
<li>
Specify the desired way to provide the tenant name. This step is done over adding
the <code>tenant-id-style</code> configuration option. For more information, see the table below

</li>
<li>
Add the tenants section to the OIDC provider configuration

</li>
</ol>

<markup
lang="yaml"

>tenants:
   - name: "example-tenant"
     # ... tenant configuration options</markup>

<p>There are four ways to provide the required tenant information to Helidon by default.</p>

<div class="block-title"><span>Possible <code>tenant-id-style</code> configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 44.444%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>description</th>
<th>additional config options</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>host-header</code></td>
<td class=""><doc-view>
<p>Tenant configuration will be selected based on your host present in the <code>Host</code> header value.</p>

</doc-view>
</td>
<td class=""><doc-view>
<p>&#160;</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>domain</code></td>
<td class=""><doc-view>
<p>Similar to the <code>host-header</code> style, but now the tenant name is identified just as
a part of the host name. By default, it selects the third domain level.</p>

<p>Example: Host header value from inbound request is <code>my.helidon.com</code> &#8594; domain level 3 is <code>my</code>,
domain level 2 is <code>helidon</code> and domain level 1 is <code>com</code>.</p>

</doc-view>
</td>
<td class=""><doc-view>
<markup
lang="yaml"

>tenant-id-domain-level: &lt;domain level&gt;</markup>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-handler</code></td>
<td class=""><doc-view>
<p>The tenant name information is expected to be provided through the configured custom header value.</p>

</doc-view>
</td>
<td class=""><doc-view>
<markup
lang="yaml"

>tenant-id-handler:
  header: "my-custom-header"</markup>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>none</code></td>
<td class=""><doc-view>
<p>No tenant name finding is used. Default tenant name <code>@default</code> is used instead.</p>

</doc-view>
</td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>You can also implement a custom way of discovering the tenant name and tenant configuration.
The custom tenant name discovery from request can be done by implementing SPI:</p>

<p><code>io.helidon.security.providers.oidc.common.spi.TenantIdProvider</code></p>

<p>and the custom tenant configuration discovery can be provided by implementing SPI:</p>

<p><code>io.helidon.security.providers.oidc.common.spi.TenantConfigProvider</code></p>


<h4 id="_available_tenant_config_options">Available tenant config options</h4>
<div class="section">
<p>Open ID Connect tenant configuration</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.oidc.common/io/helidon/security/providers/oidc/common/TenantConfig.html">io.helidon.security.providers.oidc.common.TenantConfig</a></p>


<h5 id="_configuration_options_2">Configuration options</h5>
<div class="section">
<div class="block-title"><span>Required configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the tenant.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorization-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of an authorization endpoint used to redirect users to for logging-in.</p>

<pre>If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
an attempt is made to use #identityUri(URI)/oauth2/v1/authorize.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base-scopes</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>openid</code></td>
<td class=""><doc-view>
<p>Configure base scopes.
 By default, this is <code>DEFAULT_BASE_SCOPES</code>.
 If scope has a qualifier, it must be used here.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>check-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Configure audience claim check.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client ID as generated by OIDC server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client secret as generated by OIDC server.
 Used to authenticate this application with the server when requesting
 JWT based on a code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>30000</code></td>
<td class=""><doc-view>
<p>Timeout of calls using web client.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>identity-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of the identity server, base used to retrieve OIDC metadata.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>introspect-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Endpoint to use to validate JWT.
 Either use this or set #signJwk(JwkKeys) or #signJwk(Resource).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata-well-known</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to true, metadata will be loaded from default (well known)
 location, unless it is explicitly defined using oidc-metadata-resource. If set to false, it would not be loaded
 even if oidc-metadata-resource is not defined. In such a case all URIs must be explicitly defined (e.g.
 token-endpoint-uri).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Resource configuration for OIDC Metadata
 containing endpoints to various identity services, as well as information about the identity server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Allow audience claim to be optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scope-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of the scope required by this application. This is prefixed to
 the scope name when requesting scopes from the identity server.
 Defaults to empty string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Configure one of the supported types of identity servers.</p>

<pre>If the type does not have an explicit mapping, a warning is logged and the default implementation is used.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A resource pointing to JWK with public keys of signing certificates used
 to validate JWT.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-auth</code></td>
<td class=""><doc-view>
<p>ClientAuthentication (CLIENT_SECRET_BASIC, CLIENT_SECRET_POST, CLIENT_SECRET_JWT, PRIVATE_KEY_JWT, NONE)</p>

</doc-view>
</td>
<td class=""><code>CLIENT_SECRET_BASIC</code></td>
<td class=""><doc-view>
<p>Type of authentication to use when invoking the token endpoint.
 Current supported options:</p>

<ul class="ulist">
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_BASIC</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_POST</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#NONE</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of a token endpoint used to obtain a JWT based on the authentication
 code.
 If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
 an attempt is made to use #identityUri(URI)/oauth2/v1/token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-jwt-with-jwk</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use JWK (a set of keys to validate signatures of JWT) to validate tokens.
 Use this method when you want to use default values for JWK or introspection endpoint URI.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h4 id="_how_does_that_work">How does that work?</h4>
<div class="section">
<p>Multi-tenant support requires to obtain tenant name from the incoming request. OIDC configuration is selected
based on the received tenant name. The way this tenant name has to be provided is configured via <code>tenant-id-style</code>
configuration. See <router-link to="#tenant-enable" @click.native="this.scrollFix('#tenant-enable')">How to enable tenants</router-link> for more information. After matching tenant configuration
with the received name, the rest of the OIDC flow if exactly the same as in <router-link to="#oidc-workflow" @click.native="this.scrollFix('#oidc-workflow')">How does OIDC work</router-link>.</p>

<p>Base OIDC configuration is treated as a default tenant, which is used, if no tenant name is provided. This default
tenant is having <code>@default</code> name specified.</p>

<p>It is also important to note, that each tenant configuration is based on the default tenant configuration (base OIDC configuration),
and therefore its configuration do not need to change all the properties, if they do not differ from the base OIDC
configuration.</p>

</div>

</div>

</div>


<h2 id="cors">CORS Settings</h2>
<div class="section">
<p>As an experimental feature, you can set up cross-origin handling for the redirect and logout endpoints in an optional <code>cors</code> block inside the <code>oidc</code> configuration.</p>

<p>The table below lists the configuration keys that identify the CORS characteristics.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
<col style="width: 20%;">
</colgroup>
<thead>
<tr>
<th>config key</th>
<th>type</th>
<th>default</th>
<th>description</th>
<th>CORS header name</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>allow-credentials</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class="">Sets the allow credentials flag.</td>
<td class=""><code>Access-Control-Allow-Credentials</code></td>
</tr>
<tr>
<td class=""><code>allow-headers</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed headers.</td>
<td class=""><code>Access-Control-Allow-Headers</code></td>
</tr>
<tr>
<td class=""><code>allow-methods</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed methods.</td>
<td class=""><code>Access-Control-Allow-Methods</code></td>
</tr>
<tr>
<td class=""><code>allow-origins</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed origins.</td>
<td class=""><code>Access-Control-Allow-Origins</code></td>
</tr>
<tr>
<td class=""><code>expose-headers</code></td>
<td class="">string[]</td>
<td class="">&#160;</td>
<td class="">Sets the expose headers.</td>
<td class=""><code>Access-Control-Expose-Headers</code></td>
</tr>
<tr>
<td class=""><code>max-age-seconds</code></td>
<td class="">long</td>
<td class=""><code>3600</code></td>
<td class="">Sets the maximum age.</td>
<td class=""><code>Access-Control-Max-Age</code></td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class="">Sets whether this config should be enabled or not.</td>
<td class="">n/a</td>
</tr>
</tbody>
</table>
</div>

<p>If the cross-origin configuration is disabled (<code>enabled</code> = false), then the Helidon CORS implementation ignores the cross-origin configuration entry.</p>

<p>The following example of basic cross-origin
configuration
limits cross-origin resource sharing for <code>PUT</code> and
<code>DELETE</code> operations to only <code>foo.com</code> and <code>there.com</code>:</p>

<markup
lang="yaml"

>allow-origins: ["https://foo.com", "https://there.com"]
allow-methods: ["PUT", "DELETE"]</markup>


<h3 id="_http_basic_authentication_provider">HTTP Basic Authentication Provider</h3>
<div class="section">
<p>HTTP Basic authentication support</p>


<h4 id="_setup_2">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-http-auth&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview">Overview</h4>
<div class="section">
<p>HTTP Basic Authentication provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.httpauth/io/helidon/security/providers/httpauth/HttpBasicAuthProvider.html">io.helidon.security.providers.httpauth.HttpBasicAuthProvider</a></p>

<markup
lang="text"
title="Config key"
>http-basic-auth</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_3">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the authentication cannot be verified.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundTarget">OutboundTarget[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add a new outbound target to configure identity propagation or explicit username/password.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>helidon</code></td>
<td class=""><doc-view>
<p>Set the realm to use when challenging users.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>users</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpauth_ConfigUserStore_ConfigUser">ConfigUser[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set user store to validate users.
 Removes any other stores added through #addUserStore(SecureUserStore).</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_2">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/outbound-override">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
  - http-basic-auth:
      realm: "helidon"
      users:
      - login: "john"
        password: "${CLEAR=changeit}"
        roles: ["admin"]
      - login: "jack"
        password: "changeit"
        roles: ["user", "admin"]
      outbound:
        - name: "internal-services"
          hosts: ["*.example.org"]
          # Propagates current user's identity or identity from request property
          outbound-token:
            header: "X-Internal-Auth"
        - name: "partner-service"
          hosts: ["*.partner.org"]
          # Uses this username and password
          username: "partner-user-1"
          password: "${CLEAR=changeit}"</markup>

</div>


<h4 id="_how_does_it_work">How does it work?</h4>
<div class="section">
<p>See <a target="_blank" href="https://tools.ietf.org/html/rfc7617" class="bare">https://tools.ietf.org/html/rfc7617</a>.</p>

<p><strong>Authentication of request</strong></p>

<p>When a request is received without the <code>Authorization: basic &#8230;&#8203;.</code> header, a challenge is returned to provide such
authentication.</p>

<p>When a request is received with the <code>Authorization: basic &#8230;&#8203;.</code> header, the username and password is validated
against configured users (and users obtained from custom service if any provided).</p>

<p>Subject is created based on the username and roles provided by the user store.</p>

<p><strong>Identity propagation</strong></p>

<p>When identity propagation is configured, there are several options for identifying username and password to propagate:</p>

<ol style="margin-left: 15px;">
<li>
We propagate the current username and password (inbound request must be authenticated using basic authentication).

</li>
<li>
We use username and password from an explicitly configured property (See <code>EndpointConfig.PROPERTY_OUTBOUND_ID</code>
and <code>EndpointConfig.PROPERTY_OUTBOUND_SECRET</code>)

</li>
<li>
We use username and password associated with an outbound target (see example configuration above)

</li>
</ol>

<p>Identity is propagated only if:</p>

<ol style="margin-left: 15px;">
<li>
There is an outbound target configured for the endpoint

</li>
<li>
Or there is an explicitly configured username/password for the current request (through request property)

</li>
</ol>

<p><strong>Custom user store</strong></p>

<p>Java service loader service <code>io.helidon.security.providers.httpauth.spi.UserStoreService</code> can be implemented to provide
 users to the provider, such as when validated against an internal database or LDAP server.
The user store is defined so you never need the clear text password of the user.</p>

<p><em>Warning on security of HTTP Basic Authentication (or lack thereof)</em></p>

<p>Basic authentication uses base64 encoded username and password and passes it over the network. Base64 is only encoding,
 not encryption - so anybody that gets hold of the header value can learn the actual username and password of the user.
This is a security risk and an attack vector that everybody should be aware of before using HTTP Basic Authentication.
We recommend using this approach only for testing and demo purposes.</p>

</div>

</div>


<h3 id="_http_digest_authentication_provider">HTTP Digest Authentication Provider</h3>
<div class="section">
<p>HTTP Digest authentication support</p>


<h4 id="_setup_3">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-http-auth&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_2">Overview</h4>
<div class="section">
<p>Http digest authentication security provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.httpauth/io/helidon/security/providers/httpauth/HttpDigestAuthProvider.html">io.helidon.security.providers.httpauth.HttpDigestAuthProvider</a></p>

<markup
lang="text"
title="Config key"
>http-digest-auth</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_4">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>algorithm</code></td>
<td class=""><doc-view>
<p>Algorithm (MD5)</p>

</doc-view>
</td>
<td class=""><code>MD5</code></td>
<td class=""><doc-view>
<p>Digest algorithm to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>nonce-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>86400000</code></td>
<td class=""><doc-view>
<p>How long will the nonce value be valid. When timed-out, browser will re-request username/password.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the authentication cannot be verified.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>qop</code></td>
<td class=""><doc-view>
<p>Qop (NONE, AUTH)</p>

</doc-view>
</td>
<td class=""><code>NONE</code></td>
<td class=""><doc-view>
<p>Only <code>AUTH</code> supported. If left empty, uses the legacy approach (older RFC version). <code>AUTH-INT</code> is not supported.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>Helidon</code></td>
<td class=""><doc-view>
<p>Set the realm to use when challenging users.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The nonce is encrypted using this secret - to make sure the nonce we get back was generated by us and to
 make sure we can safely time-out nonce values.
 This secret must be the same for all service instances (or all services that want to share the same authentication).
 Defaults to a random password - e.g. if deployed to multiple servers, the authentication WILL NOT WORK. You MUST
 provide your own password to work in a distributed environment with non-sticky load balancing.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>users</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpauth_ConfigUserStore_ConfigUser">ConfigUser[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set user store to obtain passwords and roles based on logins.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_3">Example code</h4>
<div class="section">
<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
  - http-digest-auth:
      realm: "helidon"
      server-secret: "${CLEAR=service-wide-secret-not-known-outside}"
      users:
      - login: "john"
        password: "${CLEAR=changeit}"
        roles: ["admin"]
      - login: "jack"
        password: "changeit"
        roles: ["user", "admin"]</markup>

</div>


<h4 id="_how_does_it_work_2">How does it work?</h4>
<div class="section">
<p>See <a target="_blank" href="https://tools.ietf.org/html/rfc7616" class="bare">https://tools.ietf.org/html/rfc7616</a>.</p>

<p><strong>Authentication of request</strong></p>

<p>When a request is received without the <code>Authorization: digest &#8230;&#8203;.</code> header, a challenge is returned to provide such
authentication using <code>WWW-Authenticate</code> header.</p>

<p>When a request is received with the <code>Authorization: digest &#8230;&#8203;.</code> header, the request is validated
against configured users (and users obtained from custom service if any provided).</p>

<p>Subject is created based on the username and roles provided by the user store.</p>

<p><strong>Custom user store</strong></p>

<p>Java service loader service <code>io.helidon.security.providers.httpauth.spi.UserStoreService</code> can be implemented to provide
 users to the provider, such as when validated against an internal database or LDAP server.
The user store is defined so you never need the clear text password of the user.</p>

<p><em>Note on security of HTTP Digest Authentication</em></p>

<p>These authentication schemes
should be <em>obsolete</em>, though they provide a very easy way to test a protected resource.</p>

</div>

</div>


<h3 id="_header_authentication_provider">Header Authentication Provider</h3>
<div class="section">
<p>Asserts user or service identity based on a value of a header.</p>


<h4 id="_setup_4">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-header&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_3">Overview</h4>
<div class="section">
<p>Security provider that extracts a username (or service name) from a header.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.header/io/helidon/security/providers/header/HeaderAtnProvider.html">io.helidon.security.providers.header.HeaderAtnProvider</a></p>

<markup
lang="text"
title="Config key"
>header-atn</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_5">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>atn-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to extract username from request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to authenticate requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the username cannot be extracted.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundTarget">OutboundTarget[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure outbound target for identity propagation.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to create outbound headers to propagate identity.
 If not defined, #atnTokenHandler will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to propagate identity.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_4">Example code</h4>
<div class="section">
<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    header-atn:
      atn-token:
        header: "X-AUTH-USER"
      outbound:
        - name: "internal-services"
          hosts: ["*.example.org"]
          # propagates the current user or service id using the same header as authentication
        - name: "partner-service"
          hosts: ["*.partner.org"]
          # propagates an explicit username in a custom header
          username: "service-27"
          outbound-token:
            header: "X-Service-Auth"</markup>

</div>


<h4 id="_how_does_it_work_3">How does it work?</h4>
<div class="section">
<p>This provider inspects a specified request header and extracts the username/service name from it and
asserts it as current subject&#8217;s principal.</p>

<p>This can be used when we use perimeter authentication (e.g. there is a gateway that takes
care of authentication and propagates the user in a header).</p>

<p><strong>Identity propagation</strong></p>

<p>Identity is propagated only if an outbound target matches the target service.</p>

<p>The following options exist when propagating identity:
1. We propagate the current username using the configured header
2. We use username associated with an outbound target (see example configuration above)</p>

<p><strong>Caution</strong></p>

<p>When using this provider, you must be sure the header cannot be explicitly configured by a user or another service.
All requests should go through a gateway that removes this header from inbound traffic, and only configures it for
authenticated users/services.
Another option is to use this with fully trusted parties (such as services within a single company, on a single
protected network not accessible to any users), and of course for testing and demo purposes.</p>

</div>

</div>


<h3 id="_http_signatures_provider">HTTP Signatures Provider</h3>
<div class="section">
<p>Support for HTTP Signatures.</p>


<h4 id="_setup_5">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-http-sign&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_4">Overview</h4>
<div class="section">
<p>HTTP header signature provider.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.httpsign/io/helidon/security/providers/httpsign/HttpSignProvider.html">io.helidon.security.providers.httpsign.HttpSignProvider</a></p>

<markup
lang="text"
title="Config key"
>http-signatures</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_6">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backward-compatible-eol</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Enable support for Helidon versions before 3.0.0 (exclusive).</p>

<pre>Until version 3.0.0 (exclusive) there was a trailing end of line added to the signed
data.
To be able to communicate cross versions, we must configure this when talking to older versions of Helidon.
Default value is `false`. In Helidon 2.x, this switch exists as well and the default is `true`, to
allow communication between versions as needed.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>headers</code></td>
<td class=""><doc-view>
<p>HttpSignHeader[&#93; (SIGNATURE, AUTHORIZATION, CUSTOM)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add a header that is validated on inbound requests. Provider may support more than
 one header to validate.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>inbound.keys</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpsign_InboundClientDefinition">InboundClientDefinition[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add inbound configuration. This is used to validate signature and authenticate the
 party.</p>

<pre>The same can be done through configuration:
&lt;pre&gt;
{
 name = "http-signatures"
 class = "HttpSignProvider"
 http-signatures {
     inbound {
         # This configures the InboundClientDefinition
         keys: [
         {
             key-id = "service1"
             hmac.secret = "${CLEAR=changeit}"
         }]
     }
 }
}
&lt;/pre&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Set whether the signature is optional. If set to true (default), this provider will
 SecurityResponse.SecurityStatus#ABSTAIN from this request if signature is not
 present. If set to false, this provider will SecurityResponse.SecurityStatus#FAILURE fail
 if signature is not present.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add outbound targets to this builder.
 The targets are used to chose what to do for outbound communication.
 The targets should have OutboundTargetDefinition attached through
 OutboundTarget.Builder#customObject(Class, Object) to tell us how to sign
 the request.</p>

<pre>The same can be done through configuration:
&lt;pre&gt;
{
 name = "http-signatures"
 class = "HttpSignProvider"
 http-signatures {
     targets: [
     {
         name = "service2"
         hosts = ["localhost"]
         paths = ["/service2/.*"]</pre>
<pre>         # This configures the OutboundTargetDefinition
         signature {
             key-id = "service1"
             hmac.secret = "${CLEAR=changeit}"
         }
     }]
 }
}
&lt;/pre&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>helidon</code></td>
<td class=""><doc-view>
<p>Realm to use for challenging inbound requests that do not have "Authorization" header
 in case header is HttpSignHeader#AUTHORIZATION and singatures are not optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-headers</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpsign_SignedHeadersConfig_HeadersConfig">HeadersConfig[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Override the default inbound required headers (e.g. headers that MUST be signed and
 headers that MUST be signed IF present).</p>

<pre>Defaults:</pre>
<ul class="ulist">
<li>
<p>get, head, delete methods: date, (request-target), host are mandatory; authorization if present (unless we are
creating/validating the HttpSignHeader#AUTHORIZATION ourselves</p>

</li>
<li>
<p>put, post: same as above, with addition of: content-length, content-type and digest if present</p>

</li>
<li>
<p>for other methods: date, (request-target)</p>

</li>
</ul>

<p>Note that this provider DOES NOT validate the "Digest" HTTP header, only the signature.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_5">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/webserver-signatures">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    - http-signatures:
        inbound:
          keys:
            - key-id: "service1-hmac"
              principal-name: "Service1 - HMAC signature"
              hmac.secret: "${CLEAR=changeit}"
            - key-id: "service1-rsa"
              principal-name: "Service1 - RSA signature"
              public-key:
                keystore:
                  resource.path: "src/main/resources/keystore.p12"
                  passphrase: "changeit"
                  cert.alias: "service_cert"
        outbound:
          - name: "service2-hmac"
            hosts: ["localhost"]
            paths: ["/service2"]
            signature:
              key-id: "service1-hmac"
              hmac.secret: "${CLEAR=changeit}"
          - name: "service2-rsa"
            hosts: ["localhost"]
            paths: ["/service2-rsa.*"]
            signature:
              key-id: "service1-rsa"
              private-key:
                keystore:
                  resource.path: "src/main/resources/keystore.p12"
                  passphrase: "changeit"
                  key.alias: "myPrivateKey"</markup>

</div>


<h4 id="_signature_basics">Signature basics</h4>
<div class="section">
<ul class="ulist">
<li>
<p>standard: based on <a target="_blank" href="https://tools.ietf.org/html/draft-cavage-http-signatures-03" class="bare">https://tools.ietf.org/html/draft-cavage-http-signatures-03</a></p>

</li>
<li>
<p>key-id: an arbitrary string used to locate signature configuration - when a
request is received the provider locates validation configuration based on this
id (e.g. HMAC shared secret or RSA public key). Commonly used meanings are: key
fingerprint (RSA); API Key</p>

</li>
</ul>

</div>


<h4 id="_how_does_it_work_4">How does it work?</h4>
<div class="section">
<p><strong>Inbound Signatures</strong>
We act as a server and another party is calling us with a signed HTTP request.
We validate the signature and assume identity of the caller.</p>

<p><strong>Outbound Signatures</strong>
We act as a client and we sign our outgoing requests.
If there is a matching <code>outbound</code> target specified in configuration,
 its configuration will be applied for signing the outgoing request,
 otherwise there is no signature added</p>

</div>

</div>


<h3 id="_idcs_role_mapper">IDCS Role Mapper</h3>
<div class="section">
<p>A role mapper to retrieve roles from Oracle IDCS.</p>


<h4 id="_setup_6">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-idcs-mapper&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_single_tenant_idcs_role_mapper">Single-tenant IDCS Role Mapper</h4>
<div class="section">
<p>IDCS role mapping provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.idcs.mapper/io/helidon/security/providers/idcs/mapper/IdcsRoleMapperProvider.html">io.helidon.security.providers.idcs.mapper.IdcsRoleMapperProvider</a></p>

<markup
lang="text"
title="Config key"
>idcs-role-mapper</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.SubjectMappingProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_7">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cache-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_EvictableCache">EvictableCache</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.common.EvictableCache for role caching.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-idcs-subject-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>user</code></td>
<td class=""><doc-view>
<p>Configure subject type to use when requesting roles from IDCS.
 Can be either #IDCS_SUBJECT_TYPE_USER or #IDCS_SUBJECT_TYPE_CLIENT.
 Defaults to #IDCS_SUBJECT_TYPE_USER.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_oidc_common_OidcConfig">OidcConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.oidc.common.OidcConfig instance, e.g. when using it also for OIDC
 provider.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>subject-types</code></td>
<td class=""><doc-view>
<p>SubjectType[&#93; (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Add a supported subject type.
 If none added, io.helidon.security.SubjectType#USER is used.
 If any added, only the ones added will be used (e.g. if you want to use
 both io.helidon.security.SubjectType#USER and io.helidon.security.SubjectType#SERVICE,
 both need to be added.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_multi_tenant_idcs_role_mapper">Multi-tenant IDCS Role Mapper</h4>
<div class="section">
<p>Multitenant IDCS role mapping provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.idcs.mapper/io/helidon/security/providers/idcs/mapper/IdcsMtRoleMapperProvider.html">io.helidon.security.providers.idcs.mapper.IdcsMtRoleMapperProvider</a></p>

<markup
lang="text"
title="Config key"
>idcs-role-mapper</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.SubjectMappingProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_8">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cache-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_EvictableCache">EvictableCache</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.common.EvictableCache for role caching.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-idcs-subject-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>user</code></td>
<td class=""><doc-view>
<p>Configure subject type to use when requesting roles from IDCS.
 Can be either #IDCS_SUBJECT_TYPE_USER or #IDCS_SUBJECT_TYPE_CLIENT.
 Defaults to #IDCS_SUBJECT_TYPE_USER.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idcs-app-name-handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure token handler for IDCS Application name.
 By default the header <code>IdcsMtRoleMapperProvider#IDCS_APP_HEADER</code> is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idcs-tenant-handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure token handler for IDCS Tenant ID.
 By default the header <code>IdcsMtRoleMapperProvider#IDCS_TENANT_HEADER</code> is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_oidc_common_OidcConfig">OidcConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.oidc.common.OidcConfig instance, e.g. when using it also for OIDC
 provider.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>subject-types</code></td>
<td class=""><doc-view>
<p>SubjectType[&#93; (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Add a supported subject type.
 If none added, io.helidon.security.SubjectType#USER is used.
 If any added, only the ones added will be used (e.g. if you want to use
 both io.helidon.security.SubjectType#USER and io.helidon.security.SubjectType#SERVICE,
 both need to be added.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_6">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/idcs-login/">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    - idcs-role-mapper:
        multitenant: false
        oidc-config:
            client-id: "client-id"
            client-secret: "changeit"
            identity-uri: "IDCS identity server address"</markup>

</div>


<h4 id="_how_does_it_work_5">How does it work?</h4>
<div class="section">
<p>The provider asks the IDCS server to provide list of roles for the currently
authenticated user.
The result is cached for a certain period of time (see <code>cache-config</code> above).</p>

</div>

</div>


<h3 id="_abac_provider">ABAC Provider</h3>
<div class="section">
<p>Attribute based access control authorization provider.</p>


<h4 id="_setup_7">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-abac&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_5">Overview</h4>
<div class="section">
<p>Attribute Based Access Control provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.abac/io/helidon/security/providers/abac/AbacProvider.html">io.helidon.security.providers.abac.AbacProvider</a></p>

<markup
lang="text"
title="Config key"
>abac</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthorizationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_9">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>fail-if-none-validated</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to fail if NONE of the attributes is validated.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>fail-on-unvalidated</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to fail if any attribute is left unvalidated.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_7">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/attribute-based-access-control">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    - abac:</markup>

</div>


<h4 id="_configuration_options_10">Configuration options</h4>
<div class="section">
<p>The following table shows all configuration options of the provider and their default values</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>fail-on-unvalidated</code></td>
<td class=""><code>true</code></td>
<td class="">"Unvalidated" means: an attribute is defined, but there is no validator available for it</td>
</tr>
<tr>
<td class=""><code>fail-if-none-validated</code></td>
<td class=""><code>true</code></td>
<td class="">"None validated" means: there was not a single attribute that was validated</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_how_does_it_work_6">How does it work?</h4>
<div class="section">
<p>ABAC uses available validators and validates them against attributes of the authenticated
 user.</p>

<p>Combinations of <code>fail-on-unvalidated</code> and <code>fail-if-none-validated</code>:</p>

<ol style="margin-left: 15px;">
<li>
<code>true</code> &amp; <code>true</code>: Will fail if any attribute is not validated and if any has failed validation

</li>
<li>
<code>false</code> &amp; <code>true</code>: Will fail if there is one or more attributes present and NONE of them is validated or if any has failed validation,
Will NOT fail if there is at least one validated attribute and any number of not validated attributes (and NONE failed)

</li>
<li>
<code>false</code> &amp; <code>false</code>: Will fail if there is any attribute that failed validation,
Will NOT fail if there are no failed validation or if there are NONE validated

</li>
</ol>

<p>Any attribute of the following objects can be used:</p>

<ul class="ulist">
<li>
<p>environment (such as time of request) - e.g. env.time.year</p>

</li>
<li>
<p>subject (user) - e.g. subject.principal.id</p>

</li>
<li>
<p>subject (service) - e.g. service.principal.id</p>

</li>
<li>
<p>object (must be explicitly invoked by developer in code, as object cannot be automatically added to security context) - e.g. object.owner</p>

</li>
</ul>

<p>This provider checks that all defined ABAC validators are validated.
If there is a definition for a validator that is not checked,
the request is denied (depending on configuration as mentioned above).</p>

<p>ABAC provider also allows an object to be used in authorization process, such
as when evaluating if an object&#8217;s owner is the current user.
The following example uses the Expression language validator to demonstrate the point
in a JAX-RS resource:</p>

<markup
lang="java"
title="Example of using an object"
>@Authenticated
@Path("/abac")
public class AbacResource {
    @GET
    @Authorized(explicit = true)
    @PolicyStatement("${env.time.year &gt;= 2017 &amp;&amp; object.owner == subject.principal.id}")
    public Response process(@Context SecurityContext context) {
        // probably looked up from a database
        SomeResource res = new SomeResource("user");
        AuthorizationResponse atzResponse = context.authorize(res);

        if (atzResponse.isPermitted()) {
            //do the update
            return Response.ok().entity("fine, sir").build();
        } else {
            return Response.status(Response.Status.FORBIDDEN)
                    .entity(atzResponse.description().orElse("Access not granted"))
                    .build();
        }
    }
}</markup>

<p><strong>The following validators are implemented:</strong></p>

<ul class="ulist">
<li>
<p><router-link to="#_role_validator" @click.native="this.scrollFix('#_role_validator')">Roles</router-link></p>

</li>
<li>
<p><router-link to="#_scope_validator" @click.native="this.scrollFix('#_scope_validator')">Scopes</router-link></p>

</li>
<li>
<p><router-link to="#_expression_language_policy_validator" @click.native="this.scrollFix('#_expression_language_policy_validator')">EL Policy</router-link></p>

</li>
</ul>

</div>


<h4 id="_role_validator">Role Validator</h4>
<div class="section">
<p>Checks whether user/service is in either of the required role(s).</p>

<p>Configuration Key: <code>role-validator</code></p>

<p>Annotations: <code>@RolesAllowed</code>, <code>@RoleValidator.Roles</code></p>

<markup
lang="yaml"
title="Configuration example for <code>WebServer</code>"
>security:
  web-server.paths:
    - path: "/user[/{*}]"
      roles-allowed: ["user"]</markup>

<markup
lang="java"
title="JAX-RS example"
>@RolesAllowed("user")
@RoleValidator.Roles(value = "service_role", subjectType = SubjectType.SERVICE)
@Authenticated
@Path("/abac")
public class AbacResource {
}</markup>


<h5 id="_interaction_with_jax_rs_sub_resource_locators">Interaction with JAX-RS sub-resource locators</h5>
<div class="section">
<p>When using sub-resource locators in JAX-RS, the roles allowed are collected from each "level" of
execution:
- Application class annotations
- Resource class annotations + resource method annotations
- Sub-resource class annotations + sub-resource method annotations
- Sub-resource class annotations + sub-resource method annotations (for every sub-resource on the path)</p>

<p>The <code>RolesAllowed</code> or <code>Roles</code> annotation to be used is the last one in the path as defined above.</p>

<p><em>Example 1:</em>
There is a <code>RolesAllowed("admin")</code> defined on a sub-resource locator resource class.
In this case the required role is <code>admin</code>.</p>

<p><em>Example 2:</em>
There is a <code>RolesAllowed("admin")</code> defined on a sub-resource locator resource class and
a <code>RolesAllowed("user")</code> defined on the method of the sub-resource that provides the response.
In this case the required role is <code>user</code>.</p>

</div>

</div>


<h4 id="_scope_validator">Scope Validator</h4>
<div class="section">
<p>Checks whether user has all the required scopes.</p>

<p>Configuration Key: <code>scope-validator</code></p>

<p>Annotations: <code>@Scope</code></p>

<markup
lang="yaml"
title="Configuration example for <code>WebServer</code>"
>security:
  web-server.paths:
    - path: "/user[/{*}]"
      abac.scopes:
        ["calendar_read", "calendar_edit"]</markup>

<markup
lang="java"
title="JAX-RS example"
>@Scope("calendar_read")
@Scope("calendar_edit")
@Authenticated
@Path("/abac")
public class AbacResource {
}</markup>

</div>


<h4 id="_expression_language_policy_validator">Expression Language Policy Validator</h4>
<div class="section">
<p>Policy executor using Java EE policy expression language (EL)</p>

<p>Configuration Key: <code>policy-javax-el</code></p>

<p>Annotations: <code>@PolicyStatement</code></p>

<p>Example of a policy statement: <code>${env.time.year &gt;= 2017}</code></p>

<markup
lang="yaml"
title="Configuration example for <code>WebServer</code>"
>security:
  web-server.paths:
    - path: "/user[/{*}]"
      policy:
        statement: "hasScopes('calendar_read','calendar_edit') AND timeOfDayBetween('8:15', '17:30')"</markup>

<markup
lang="java"
title="JAX-RS example"
>@PolicyStatement("${env.time.year &gt;= 2017}")
@Authenticated
@Path("/abac")
public class AbacResource {
}</markup>

</div>

</div>


<h3 id="_google_login_provider">Google Login Provider</h3>
<div class="section">
<p>Authenticates a token from request against Google identity provider</p>


<h4 id="_setup_8">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-google-login&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_6">Overview</h4>
<div class="section">
<p>Google Authentication provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.google.login/io/helidon/security/providers/google/login/GoogleTokenProvider.html">io.helidon.security.providers.google.login.GoogleTokenProvider</a></p>

<markup
lang="text"
title="Config key"
>google-login</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_11">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Google application client id, to validate that the token was generated by Google for us.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>If set to true, this provider will return io.helidon.security.SecurityResponse.SecurityStatus#ABSTAIN instead
 of failing in case of invalid request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Outbound configuration - a set of outbound targets that
 will have the token propagated.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set proxy host when talking to Google.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>80</code></td>
<td class=""><doc-view>
<p>Set proxy port when talking to Google.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>helidon</code></td>
<td class=""><doc-view>
<p>Set the authentication realm to build challenge, defaults to "helidon".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class=""><code>&#x60;Authorization&#x60; header with &#x60;bearer&#x60; prefix</code></td>
<td class=""><doc-view>
<p>Token provider to extract Google access token from request, defaults to "Authorization" header with a "bearer " prefix.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_8">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/google-login">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    - provider:
        client-id: "Google client id"</markup>

</div>


<h4 id="_how_does_it_work_7">How does it work?</h4>
<div class="section">
<p>We expect to receive a token (with sufficient scopes) from the inbound request,
 such as when using the Google login button on a page.
The page has access to the token in javascript and can send it to backend with
every request in a header field (<code>Authorization</code> with `bearer ` prefix is assumed by default).</p>

<p>Once we receive the token in Helidon, we parse it and:</p>

<ol style="margin-left: 15px;">
<li>
Validate if it timed out locally

</li>
<li>
Return a cached response (see <code>EvictableCache</code> with default values)

</li>
<li>
Otherwise verify using Google API - <code>GoogleIdTokenVerifier</code>

</li>
</ol>

<p>We build a subject from the Google token with the following attributes filled (if in token):</p>

<ul class="ulist">
<li>
<p>userId</p>

</li>
<li>
<p>email</p>

</li>
<li>
<p>name</p>

</li>
<li>
<p>emailVerified</p>

</li>
<li>
<p>locale</p>

</li>
<li>
<p>family_name</p>

</li>
<li>
<p>given_name</p>

</li>
<li>
<p>picture (URL)</p>

</li>
</ul>

<p><strong>Outbound security</strong>
The token will be propagated to outbound calls if an outbound target exists
that matches the invoked endpoint (see <code>outbound</code> configuration above).</p>

</div>

</div>


<h3 id="_jwt_provider">JWT Provider</h3>
<div class="section">
<p>JWT token authentication and outbound security provider.</p>


<h4 id="_setup_9">Setup</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-providers-jwt&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_overview_7">Overview</h4>
<div class="section">
<p>JWT authentication provider</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.jwt/io/helidon/security/providers/jwt/JwtProvider.html">io.helidon.security.providers.jwt.JwtProvider</a></p>

<markup
lang="text"
title="Config key"
>jwt</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>

</div>


<h4 id="_configuration_options_12">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>allow-impersonation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to allow impersonation by explicitly overriding
 username from outbound requests using io.helidon.security.EndpointConfig#PROPERTY_OUTBOUND_ID
 property.
 By default this is not allowed and identity can only be propagated.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>allow-unsigned</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Configure support for unsigned JWT.
 If this is set to <code>true</code> any JWT that has algorithm
 set to <code>none</code> and no <code>kid</code> defined will be accepted.
 Note that this has serious security impact - if JWT can be sent
  from a third party, this allows the third party to send ANY JWT
  and it would be accpted as valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Token handler to extract username from request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>JWK resource used to verify JWTs created by other parties.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwt-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience expected in inbound JWTs.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.verify-signature</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Configure whether to verify signatures.
 Signatures verification is enabled by default. You can configure the provider
 not to verify signatures.</p>

<pre>&lt;b&gt;Make sure your service is properly secured on network level and only
accessible from a secure endpoint that provides the JWTs when signature verification
is disabled. If signature verification is disabled, this service will accept &lt;i&gt;ANY&lt;/i&gt; JWT&lt;/b&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to authenticate requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the username cannot be extracted.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to propagate identity.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of outbound rules.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>JWK resource used to sign JWTs created by us.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwt-issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer used to create new JWTs.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-jwt-groups</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Claim <code>groups</code> from JWT will be used to automatically add
  groups to current subject (may be used with jakarta.annotation.security.RolesAllowed annotation).</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_example_code_9">Example code</h4>
<div class="section">
<p>See the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/security/outbound-override">example</a> on GitHub.</p>

<markup
lang="yaml"
title="Configuration example"
>security:
  providers:
    - provider:
        atn-token:
          jwk.resource.resource-path: "verifying-jwk.json"
          jwt-audience: "http://my.service"
        sign-token:
          jwk.resource.resource-path: "signing-jwk.json"
          jwt-issuer: "http://my.server/identity"
          outbound:
          - name: "propagate-token"
            hosts: ["*.internal.org"]
          - name: "generate-token"
            hosts: ["1.partner-service"]
            jwk-kid: "partner-1"
            jwt-kid: "helidon"
            jwt-audience: "http://1.partner-service"</markup>

</div>


<h4 id="_how_does_it_work_8">How does it work?</h4>
<div class="section">
<p>JSON Web Token (JWT) provider has support for authentication and outbound security.</p>

<p>Authentication is based on validating the token (signature, valid before etc.) and on asserting the subject
of the JWT subject claim.</p>

<p>For outbound, we support either token propagation (e.g. the token from request is propagated further) or
support for generating a brand new token based on configuration of this provider.</p>

</div>

</div>

</div>

</doc-view>
