<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#config" @click.native="this.scrollFix('#config')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.0.md">OpenAPI specification</a> defines a standard way to express the interface exposed by a REST service.</p>

<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.1/microprofile-openapi-spec-3.1.html">MicroProfile OpenAPI spec</a> explains how MicroProfile embraces OpenAPI, adding annotations, configuration, and a service provider interface (SPI).</p>

<p>OpenAPI support in Helidon SE draws its inspiration from MicroProfile OpenAPI but does not implement the spec because Helidon SE does not support annotations.</p>

<p>The OpenAPI support in Helidon SE performs
two main tasks:</p>

<ul class="ulist">
<li>
<p>Build an in-memory model of the REST API your service implements.</p>

</li>
<li>
<p>Expose the model in text format (YAML or JSON) via the <code>/openapi</code> endpoint.</p>

</li>
</ul>

<p>To construct the model, Helidon gathers information about the service API from
a static OpenAPI document file packaged as part of your service.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable OpenAPI
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.openapi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-openapi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_automatic_registration_default">Automatic Registration (default)</h3>
<div class="section">
<p>Simply by adding the dependency described above you add support for OpenAPI to your Helidon SE application. Because Helidon
automatically discovers the OpenAPI feature, you do not have to make any changes to your application code.</p>

</div>


<h3 id="_explicit_registration">Explicit Registration</h3>
<div class="section">
<p>To control the behavior of the OpenAPI feature programmatically, you can add and configure the OpenAPI feature explicitly as
explained below.</p>


<h4 id="_create_and_register_openapifeature_in_your_application">Create and Register <code>OpenApiFeature</code> in your application</h4>
<div class="section">
<p>Helidon SE provides the <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeature.html"><code>OpenApiFeature</code></a> class
which your application uses to assemble the in-memory model and expose the <code>/openapi</code> endpoint to clients. You can
create an instance either using a static <code>create</code> method or by instantiating its
<a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeatureConfig.Builder.html"><code>Builder</code></a>.
The <router-link to="#register_openapifeature" @click.native="this.scrollFix('#register_openapifeature')">example below</router-link>  illustrates one way to do this.</p>

</div>


<h4 id="_furnish_openapi_information_about_your_endpoints">Furnish OpenAPI information about your endpoints</h4>
<div class="section">
<p>Your application supplies data for the OpenAPI model using a static OpenAPI file.</p>


<h5 id="_provide_a_static_openapi_file">Provide a static OpenAPI file</h5>
<div class="section">
<p>Add a static file at <code>META-INF/openapi.yml</code>, <code>META-INF/openapi.yaml</code>,
or <code>META-INF/openapi.json</code>. Tools such as Swagger let you describe your app&#8217;s API
and they then generate an OpenAPI document file which you can include in your application
so OpenAPI can use it.</p>

</div>

</div>

</div>


<h3 id="_accessing_the_rest_endpoint">Accessing the REST Endpoint</h3>
<div class="section">
<p>Once you have added the SE OpenAPI dependency to your
project, if you are using auto-discovery&#8212;&#8203;or if you are not using auto-discovery and you have added code to register the <code>OpenApiFeature</code> object with your routing&#8212;&#8203;then
your application responds to the built-in endpoint&#8201;&#8212;&#8201;<code>/openapi</code>&#8201;&#8212;&#8201;and returns the OpenAPI document describing the endpoints
in your application.</p>

<p>The
default format of the OpenAPI document is YAML.
There is not yet an adopted IANA YAML media type, but a proposed one specifically
for OpenAPI documents that has some support is <code>application/vnd.oai.openapi</code>.
That is what Helidon returns by default.</p>

<p>In addition, a client can specify the HTTP header <code>Accept</code> as either <code>application/vnd.oai.openapi+json</code> or
<code>application/json</code> to request JSON. Alternatively, the client can pass the query parameter <code>format</code> as either <code>JSON</code>
or <code>YAML</code> to receive <code>application/json</code> or <code>application/vnd.oai.openapi</code> (YAML) output, respectively.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Helidon SE provides an API for creating and setting up the REST endpoint which serves OpenAPI documents to clients
at the <code>/openapi</code> path. Use either static methods on <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeature.html"><code>OpenApiFeature</code></a>
or use its <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeatureConfig.Builder.html"><code>Builder</code></a>.
Then add that instance or builder to your application&#8217;s routing. The <router-link to="#register_openapifeature" @click.native="this.scrollFix('#register_openapifeature')">example</router-link> below shows how to do this.</p>

</div>


<h2 id="config">Configuration</h2>
<div class="section">
<p>Helidon SE OpenAPI configuration supports the following settings:</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeature.html">io.helidon.openapi.OpenApiFeature</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>openapi</code></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>CORS config.</p>

<pre>@return CORS config</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the feature should be enabled.</p>

<pre>@return `true` if enabled, `false` otherwise</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>manager</code></td>
<td class=""><doc-view>
<p>io.helidon.openapi.OpenApiManager (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>OpenAPI manager.</p>

<pre>@return the OpenAPI manager</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>permit-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow anybody to access the endpoint.</p>

<pre>@return whether to permit access to metrics endpoint to anybody, defaults to `true`
@see #roles()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Hints for role names the user is expected to be in.</p>

<pre>@return list of hints</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>services</code></td>
<td class=""><doc-view>
<p>io.helidon.openapi.OpenApiService[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>OpenAPI services.</p>

<pre>@return the OpenAPI services</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>static-file</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path of the static OpenAPI document file. Default types are <code>json</code>, <code>yaml</code>, and <code>yml</code>.</p>

<pre>@return location of the static OpenAPI document file</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/openapi</code></td>
<td class=""><doc-view>
<p>Web context path for the OpenAPI endpoint.</p>

<pre>@return webContext to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon SE provides a <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.8/examples/openapi">complete OpenAPI example</a>
based on the SE QuickStart sample app.</p>

<p>Most Helidon SE applications need only add the dependency as explained above; Helidon discovers and registers OpenAPI
automatically. The example below shows how to create and register <code>OpenApiFeature</code> explicitly instead.</p>


<h3 id="register_openapifeature">Register <code>OpenApiFeature</code> explicitly</h3>
<div class="section">
<markup
lang="java"
title="Java Code to Create and Register <code>OpenApiFeature</code>"
>WebServer server = WebServer.builder()
        .config(config.get("server"))
        .addFeature(OpenApiFeature.create(config.get("openapi"))) <span class="conum" data-value="1" />
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Adds the <code>OpenApiFeature</code> service to your server using the <code>openapi</code> section from configuration.</li>
</ul>

<p>If you need programmatic control over the <code>OpenApiFeature</code> instance, invoke <code>OpenApiFeature.builder()</code> to get an
<code>OpenApiFeature.Builder</code> object and work with it, then invoke the builder&#8217;s <code>build</code> method and pass the resulting
<code>OpenApiFeature</code> instance to the <code>WebServer.Builder</code> <code>addFeature</code> method.</p>

</div>

</div>

</doc-view>
