/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.metrics.api.RegistryFilterSettings;
import java.util.regex.Pattern;

class RegistryFilterSettingsImpl
implements RegistryFilterSettings {
    private final Pattern includePattern;
    private final Pattern excludePattern;

    static Builder builder() {
        return new Builder();
    }

    private RegistryFilterSettingsImpl(Builder builder) {
        this.includePattern = builder.includeFilter == null || builder.includeFilter.isBlank() ? null : Pattern.compile(builder.includeFilter);
        this.excludePattern = builder.excludeFilter == null || builder.excludeFilter.isBlank() ? null : Pattern.compile(builder.excludeFilter);
    }

    @Override
    public boolean passes(String metricName) {
        return !(this.excludePattern != null && this.excludePattern.matcher(metricName).matches() || this.includePattern != null && !this.includePattern.matcher(metricName).matches());
    }

    static class Builder
    implements RegistryFilterSettings.Builder {
        private String includeFilter;
        private String excludeFilter;

        Builder() {
        }

        public RegistryFilterSettings build() {
            return new RegistryFilterSettingsImpl(this);
        }

        @Override
        public RegistryFilterSettings.Builder exclude(String excludeFilter) {
            this.excludeFilter = excludeFilter;
            return this;
        }

        @Override
        public RegistryFilterSettings.Builder include(String includeFilter) {
            this.includeFilter = includeFilter;
            return this;
        }

        @Override
        public RegistryFilterSettings.Builder config(Config config) {
            config.get("exclude").asString().ifPresent(this::exclude);
            config.get("include").asString().ifPresent(this::include);
            return this;
        }
    }
}

