/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.metrics.api.RegistryFilterSettings;
import io.helidon.metrics.api.RegistrySettings;

class RegistrySettingsImpl
implements RegistrySettings {
    private final boolean isEnabled;
    private final RegistryFilterSettings registryFilterSettings;

    static Builder builder() {
        return new Builder();
    }

    protected RegistrySettingsImpl(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.registryFilterSettings = (RegistryFilterSettings)builder.registryFilterSettingsBuilder.build();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isMetricEnabled(String dottedName) {
        return this.isEnabled && this.registryFilterSettings.passes(dottedName);
    }

    static class Builder
    implements RegistrySettings.Builder {
        private boolean isEnabled = true;
        private RegistryFilterSettings.Builder registryFilterSettingsBuilder = RegistryFilterSettings.builder();

        Builder() {
        }

        @Override
        public RegistrySettingsImpl build() {
            return new RegistrySettingsImpl(this);
        }

        @Override
        public RegistrySettings.Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public RegistrySettings.Builder filterSettings(RegistryFilterSettings.Builder registryFilterSettingsBuilder) {
            this.registryFilterSettingsBuilder = registryFilterSettingsBuilder;
            return this;
        }

        @Override
        public RegistrySettings.Builder config(Config registrySettings) {
            registrySettings.get("enabled").asBoolean().ifPresent(this::enabled);
            registrySettings.get("filter").as(RegistryFilterSettings.Builder::create).ifPresent(this::filterSettings);
            return this;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

