/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Wrapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public interface Meter
extends Wrapper {
    public Id id();

    public Optional<String> baseUnit();

    public Optional<String> description();

    public Type type();

    public Optional<String> scope();

    public static class BaseUnits {
        public static final String NONE = "none";
        public static final String BITS = "bits";
        public static final String KILOBITS = "kilobits";
        public static final String MEGABITS = "megabits";
        public static final String GIGABITS = "gigabits";
        public static final String KIBIBITS = "kibibits";
        public static final String MEBIBITS = "mebibits";
        public static final String GIBIBITS = "gibibits";
        public static final String BYTES = "bytes";
        public static final String KILOBYTES = "kilobytes";
        public static final String MEGABYTES = "megabytes";
        public static final String GIGABYTES = "gigabytes";
        public static final String NANOSECONDS = "nanoseconds";
        public static final String MICROSECONDS = "microseconds";
        public static final String MILLISECONDS = "milliseconds";
        public static final String SECONDS = "seconds";
        public static final String MINUTES = "minutes";
        public static final String HOURS = "hours";
        public static final String DAYS = "days";
        public static final String PERCENT = "percent";
        public static final String PER_SECOND = "per_second";

        private BaseUnits() {
        }
    }

    public static class Scope {
        public static final String APPLICATION = "application";
        public static final String BASE = "base";
        public static final String VENDOR = "vendor";
        public static final Set<String> BUILT_IN_SCOPES = Set.of("base", "vendor", "application");
        public static final String DEFAULT = "application";

        private Scope() {
        }
    }

    public static interface Id {
        public String name();

        public Iterable<Tag> tags();

        default public Map<String, String> tagsMap() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            this.tags().forEach(tag -> result.put(tag.key(), tag.value()));
            return result;
        }

        default public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this);
        }
    }

    public static interface Builder<B extends Builder<B, M>, M extends Meter> {
        default public B identity() {
            return (B)this;
        }

        public B tags(Iterable<Tag> var1);

        public B addTag(Tag var1);

        public B description(String var1);

        public B baseUnit(String var1);

        public B scope(String var1);

        public String name();

        public Map<String, String> tags();

        public Optional<String> description();

        public Optional<String> baseUnit();

        public Optional<String> scope();
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        TIMER,
        DISTRIBUTION_SUMMARY,
        OTHER;

    }
}

