/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;

public interface Metrics {
    public static MeterRegistry globalRegistry() {
        return MetricsFactory.getInstance().globalRegistry();
    }

    public static MeterRegistry createMeterRegistry(MetricsConfig metricsConfig) {
        return MetricsFactory.getInstance().createMeterRegistry(metricsConfig);
    }

    public static MeterRegistry createMeterRegistry() {
        return Metrics.createMeterRegistry(MetricsConfig.create());
    }

    public static <M extends Meter, B extends Meter.Builder<B, M>> M getOrCreate(B builder) {
        return Metrics.globalRegistry().getOrCreate(builder);
    }

    public static Optional<Counter> getCounter(String name, Iterable<Tag> tags) {
        return Metrics.globalRegistry().meter(Counter.class, name, tags);
    }

    public static Optional<Counter> getCounter(String name) {
        return Metrics.getCounter(name, Set.of());
    }

    public static Optional<DistributionSummary> getSummary(String name, Iterable<Tag> tags) {
        return Metrics.globalRegistry().meter(DistributionSummary.class, name, tags);
    }

    public static Optional<DistributionSummary> getSummary(String name) {
        return Metrics.getSummary(name, Set.of());
    }

    public static Optional<Gauge> getGauge(String name, Iterable<Tag> tags) {
        return Metrics.globalRegistry().meter(Gauge.class, name, tags);
    }

    public static Optional<Gauge> getGauge(String name) {
        return Metrics.getGauge(name, Set.of());
    }

    public static Optional<Timer> getTimer(String name, Iterable<Tag> tags) {
        return Metrics.globalRegistry().meter(Timer.class, name, tags);
    }

    public static Optional<Timer> getTimer(String name) {
        return Metrics.getTimer(name, Set.of());
    }

    public static <M extends Meter> Optional<M> get(Class<M> mClass, String name, Iterable<Tag> tags) {
        return Metrics.globalRegistry().meter(mClass, name, tags);
    }

    public static Tag tag(String key, String value) {
        return MetricsFactory.getInstance().tagCreate(key, value);
    }

    public static Iterable<Tag> tags(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass an even number of strings so keys and values are evenly matched");
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (int slot = 0; slot < keyValuePairs.length / 2; ++slot) {
            result.add(Tag.create(keyValuePairs[slot * 2], keyValuePairs[slot * 2 + 1]));
        }
        return result;
    }
}

