/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfig;
import io.helidon.metrics.api.MetricsConfigBlueprint;
import io.helidon.metrics.api.MetricsConfigSupport;
import io.helidon.metrics.api.ScopingConfig;
import io.helidon.metrics.api.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.metrics.api.MetricsConfigBlueprint")
public interface MetricsConfig
extends MetricsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetricsConfig instance) {
        return (Builder)MetricsConfig.builder().from(instance);
    }

    public static MetricsConfig create(Config config) {
        return ((Builder)MetricsConfig.builder().config(config)).buildPrototype();
    }

    public static MetricsConfig create() {
        return MetricsConfig.builder().buildPrototype();
    }

    public Optional<String> lookupConfig(String var1);

    @Override
    public boolean isScopeEnabled(String var1);

    @Override
    public boolean isMeterEnabled(String var1, String var2);

    public static class Builder
    extends BuilderBase<Builder, MetricsConfig>
    implements io.helidon.common.Builder<Builder, MetricsConfig> {
        private Builder() {
        }

        public MetricsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MetricsConfigImpl(this);
        }

        public MetricsConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MetricsConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<Tag> tags = new ArrayList<Tag>();
        private boolean enabled = true;
        private boolean restRequestEnabled;
        private Config config;
        private KeyPerformanceIndicatorMetricsConfig keyPerformanceIndicatorMetricsConfig;
        private ScopingConfig scoping;
        private String appName;
        private String appTagName;

        protected BuilderBase() {
        }

        public BUILDER from(MetricsConfig prototype) {
            this.enabled(prototype.enabled());
            this.keyPerformanceIndicatorMetricsConfig(prototype.keyPerformanceIndicatorMetricsConfig());
            this.addTags(prototype.tags());
            this.appName(prototype.appName());
            this.appTagName(prototype.appTagName());
            this.scoping(prototype.scoping());
            this.restRequestEnabled(prototype.restRequestEnabled());
            this.config = prototype.config();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            builder.keyPerformanceIndicatorMetricsConfig().ifPresent(this::keyPerformanceIndicatorMetricsConfig);
            this.addTags(builder.tags());
            builder.appName().ifPresent(this::appName);
            builder.appTagName().ifPresent(this::appTagName);
            builder.scoping().ifPresent(this::scoping);
            this.restRequestEnabled(builder.restRequestEnabled());
            builder.config().ifPresent(config -> this.config((Config)config));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("key-performance-indicators").map(KeyPerformanceIndicatorMetricsConfig::create).ifPresent(this::keyPerformanceIndicatorMetricsConfig);
            config.get("tags").map(MetricsConfigBlueprint::createTags).ifPresent(this::tags);
            config.get("app-name").as(String.class).ifPresent(this::appName);
            config.get("app-tag-name").as(String.class).ifPresent(this::appTagName);
            config.get("scoping").map(ScopingConfig::create).ifPresent(this::scoping);
            config.get("rest-request-enabled").as(Boolean.class).ifPresent(this::restRequestEnabled);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPerformanceIndicatorMetricsConfig(KeyPerformanceIndicatorMetricsConfig keyPerformanceIndicatorMetricsConfig) {
            Objects.requireNonNull(keyPerformanceIndicatorMetricsConfig);
            this.keyPerformanceIndicatorMetricsConfig = keyPerformanceIndicatorMetricsConfig;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPerformanceIndicatorMetricsConfig(Consumer<KeyPerformanceIndicatorMetricsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            KeyPerformanceIndicatorMetricsConfig.Builder builder = KeyPerformanceIndicatorMetricsConfig.builder();
            consumer.accept(builder);
            this.keyPerformanceIndicatorMetricsConfig(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keyPerformanceIndicatorMetricsConfig(Supplier<? extends KeyPerformanceIndicatorMetricsConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.keyPerformanceIndicatorMetricsConfig(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tags(List<? extends Tag> tags) {
            Objects.requireNonNull(tags);
            this.tags.clear();
            this.tags.addAll(tags);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTags(List<? extends Tag> tags) {
            Objects.requireNonNull(tags);
            this.tags.addAll(tags);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tags(Config tagsConfig) {
            Objects.requireNonNull(tagsConfig);
            this.tags.clear();
            this.tags.addAll(MetricsConfigBlueprint.createTags(tagsConfig));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAppName() {
            this.appName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER appName(String appName) {
            Objects.requireNonNull(appName);
            this.appName = appName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAppTagName() {
            this.appTagName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER appTagName(String appTagName) {
            Objects.requireNonNull(appTagName);
            this.appTagName = appTagName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scoping(ScopingConfig scoping) {
            Objects.requireNonNull(scoping);
            this.scoping = scoping;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scoping(Consumer<ScopingConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ScopingConfig.Builder builder = ScopingConfig.builder();
            consumer.accept(builder);
            this.scoping(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scoping(Supplier<? extends ScopingConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.scoping(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER restRequestEnabled(boolean restRequestEnabled) {
            this.restRequestEnabled = restRequestEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<KeyPerformanceIndicatorMetricsConfig> keyPerformanceIndicatorMetricsConfig() {
            return Optional.ofNullable(this.keyPerformanceIndicatorMetricsConfig);
        }

        public List<Tag> tags() {
            return this.tags;
        }

        public Optional<String> appName() {
            return Optional.ofNullable(this.appName);
        }

        public Optional<String> appTagName() {
            return Optional.ofNullable(this.appTagName);
        }

        public Optional<ScopingConfig> scoping() {
            return Optional.ofNullable(this.scoping);
        }

        public boolean restRequestEnabled() {
            return this.restRequestEnabled;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "MetricsConfigBuilder{enabled=" + this.enabled + ",keyPerformanceIndicatorMetricsConfig=" + String.valueOf(this.keyPerformanceIndicatorMetricsConfig) + ",tags=" + String.valueOf(this.tags) + ",appName=" + this.appName + ",appTagName=" + this.appTagName + ",scoping=" + String.valueOf(this.scoping) + ",restRequestEnabled=" + this.restRequestEnabled + ",config=" + String.valueOf(this.config) + "}";
        }

        protected void preBuildPrototype() {
            new MetricsConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.keyPerformanceIndicatorMetricsConfig == null) {
                collector.fatal(this.getClass(), "Property \"key-performance-indicators\" must not be null, but not set");
            }
            if (this.scoping == null) {
                collector.fatal(this.getClass(), "Property \"scoping\" must not be null, but not set");
            }
            if (this.config == null) {
                collector.fatal(this.getClass(), "Property \"config\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER appName(Optional<? extends String> appName) {
            Objects.requireNonNull(appName);
            this.appName = appName.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER appTagName(Optional<? extends String> appTagName) {
            Objects.requireNonNull(appTagName);
            this.appTagName = appTagName.orElse(null);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class MetricsConfigImpl
        implements MetricsConfig {
            private final boolean enabled;
            private final boolean restRequestEnabled;
            private final Config config;
            private final KeyPerformanceIndicatorMetricsConfig keyPerformanceIndicatorMetricsConfig;
            private final List<Tag> tags;
            private final Optional<String> appName;
            private final Optional<String> appTagName;
            private final ScopingConfig scoping;

            protected MetricsConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.keyPerformanceIndicatorMetricsConfig = builder.keyPerformanceIndicatorMetricsConfig().get();
                this.tags = List.copyOf(builder.tags());
                this.appName = builder.appName();
                this.appTagName = builder.appTagName();
                this.scoping = builder.scoping().get();
                this.restRequestEnabled = builder.restRequestEnabled();
                this.config = builder.config().get();
            }

            @Override
            public Optional<String> lookupConfig(String key) {
                return MetricsConfigSupport.lookupConfig(this, key);
            }

            @Override
            public boolean isScopeEnabled(String scope) {
                return MetricsConfigSupport.isScopeEnabled(this, scope);
            }

            @Override
            public boolean isMeterEnabled(String name, String targetScope) {
                return MetricsConfigSupport.isMeterEnabled(this, name, targetScope);
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public KeyPerformanceIndicatorMetricsConfig keyPerformanceIndicatorMetricsConfig() {
                return this.keyPerformanceIndicatorMetricsConfig;
            }

            @Override
            public List<Tag> tags() {
                return this.tags;
            }

            @Override
            public Optional<String> appName() {
                return this.appName;
            }

            @Override
            public Optional<String> appTagName() {
                return this.appTagName;
            }

            @Override
            public ScopingConfig scoping() {
                return this.scoping;
            }

            @Override
            public boolean restRequestEnabled() {
                return this.restRequestEnabled;
            }

            @Override
            public Config config() {
                return this.config;
            }

            public String toString() {
                return "MetricsConfig{enabled=" + this.enabled + ",keyPerformanceIndicatorMetricsConfig=" + String.valueOf(this.keyPerformanceIndicatorMetricsConfig) + ",tags=" + String.valueOf(this.tags) + ",appName=" + String.valueOf(this.appName) + ",appTagName=" + String.valueOf(this.appTagName) + ",scoping=" + String.valueOf(this.scoping) + ",restRequestEnabled=" + this.restRequestEnabled + ",config=" + String.valueOf(this.config) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MetricsConfig)) {
                    return false;
                }
                MetricsConfig other = (MetricsConfig)o;
                return this.enabled == other.enabled() && Objects.equals(this.keyPerformanceIndicatorMetricsConfig, other.keyPerformanceIndicatorMetricsConfig()) && Objects.equals(this.tags, other.tags()) && Objects.equals(this.appName, other.appName()) && Objects.equals(this.appTagName, other.appTagName()) && Objects.equals(this.scoping, other.scoping()) && this.restRequestEnabled == other.restRequestEnabled() && Objects.equals(this.config, other.config());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.keyPerformanceIndicatorMetricsConfig, this.tags, this.appName, this.appTagName, this.scoping, this.restRequestEnabled, this.config);
            }
        }
    }
}

