/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.config.GlobalConfig;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfig;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.ScopeConfig;
import io.helidon.metrics.api.ScopingConfig;
import java.util.Optional;
import java.util.regex.Pattern;

class MetricsConfigSupport {
    static final Pattern TAG_ASSIGNMENT_PATTERN = Pattern.compile("(.*?)(?<!\\\\)=(.*)");

    private MetricsConfigSupport() {
    }

    @Prototype.PrototypeMethod
    static Optional<String> lookupConfig(MetricsConfig metricsConfig, String key) {
        return metricsConfig.config().get(key).asString().asOptional();
    }

    @Prototype.PrototypeMethod
    static boolean isScopeEnabled(MetricsConfig metricsConfig, String scope) {
        ScopeConfig scopeConfig = metricsConfig.scoping().scopes().get(scope);
        return scopeConfig == null || scopeConfig.enabled();
    }

    @Prototype.PrototypeMethod
    static boolean isMeterEnabled(MetricsConfig metricsConfig, String name, String targetScope) {
        return true;
    }

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<MetricsConfig.BuilderBase<?, ?>> {
        public void decorate(MetricsConfig.BuilderBase<?, ?> builder) {
            if (builder.config().isEmpty()) {
                builder.config(GlobalConfig.config().get("metrics"));
            }
            if (builder.keyPerformanceIndicatorMetricsConfig().isEmpty()) {
                builder.keyPerformanceIndicatorMetricsConfig(KeyPerformanceIndicatorMetricsConfig.create());
            }
            if (builder.scoping().isEmpty()) {
                builder.scoping(ScopingConfig.create());
            }
        }
    }
}

