/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jaxrs;

import io.helidon.webclient.jaxrs.JaxRsClient;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.jersey.client.ClientAsyncExecutor;
import org.glassfish.jersey.internal.spi.AutoDiscoverable;
import org.glassfish.jersey.model.internal.CommonConfig;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=121)
public class JerseyClientAutoDiscoverable
implements AutoDiscoverable {
    private static final Logger LOGGER = Logger.getLogger(JerseyClientAutoDiscoverable.class.getName());

    public void configure(FeatureContext context) {
        context.register((Object)new EsProvider());
        Configuration jaxRsConfiguration = context.getConfiguration();
        if (jaxRsConfiguration instanceof CommonConfig) {
            CommonConfig configuration = (CommonConfig)jaxRsConfiguration;
            Object property = configuration.getProperty("jersey.config.disableDefaultProvider");
            if (null == property) {
                LOGGER.fine("Disabling all Jersey default providers (DOM, SAX, Rendered Image, XML Source, and XML Stream Source). You can enabled them by setting system property jersey.config.disableDefaultProvider to NONE");
                configuration.property("jersey.config.disableDefaultProvider", (Object)"ALL");
            } else if ("NONE".equals(property)) {
                configuration.property("jersey.config.disableDefaultProvider", null);
            }
        }
    }

    @ClientAsyncExecutor
    private static final class EsProvider
    implements ExecutorServiceProvider {
        private EsProvider() {
        }

        public ExecutorService getExecutorService() {
            return JaxRsClient.executor().get();
        }

        public void dispose(ExecutorService executorService) {
        }
    }
}

