/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.builder.api.Prototype;
import io.helidon.webserver.accesslog.AccessLogConfig;
import io.helidon.webserver.accesslog.AccessLogConfigBlueprint;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.HeaderLogEntry;
import io.helidon.webserver.accesslog.HostLogEntry;
import io.helidon.webserver.accesslog.RequestLineLogEntry;
import io.helidon.webserver.accesslog.SizeLogEntry;
import io.helidon.webserver.accesslog.StatusLogEntry;
import io.helidon.webserver.accesslog.TimeTakenLogEntry;
import io.helidon.webserver.accesslog.TimestampLogEntry;
import io.helidon.webserver.accesslog.UserIdLogEntry;
import io.helidon.webserver.accesslog.UserLogEntry;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AccessLogConfigSupport {
    private AccessLogConfigSupport() {
    }

    static class BuilderDecorator
    implements Prototype.BuilderDecorator<AccessLogConfig.BuilderBase<?, ?>> {
        private static final Pattern HEADER_ENTRY_PATTERN = Pattern.compile("%\\{(.*?)}i");

        BuilderDecorator() {
        }

        public void decorate(AccessLogConfig.BuilderBase<?, ?> target) {
            if (target.format().isPresent()) {
                BuilderDecorator.format(target, target.format().get());
                target.clearFormat();
            }
            if (target.entries().isEmpty()) {
                target.defaultLogFormat();
            }
        }

        private static void format(AccessLogConfig.BuilderBase<?, ?> builder, String format) {
            String[] formatEntries;
            switch (format) {
                case "common": {
                    builder.commonLogFormat();
                    return;
                }
                case "default": {
                    builder.defaultLogFormat();
                    return;
                }
            }
            ArrayList<AccessLogEntry> entries = new ArrayList<AccessLogEntry>();
            String[] stringArray = formatEntries = format.split(" ");
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String formatEntry;
                switch (formatEntry = stringArray[i]) {
                    case "%h": {
                        entries.add(HostLogEntry.create());
                        continue block30;
                    }
                    case "%l": {
                        entries.add(UserIdLogEntry.create());
                        continue block30;
                    }
                    case "%u": {
                        entries.add(UserLogEntry.create());
                        continue block30;
                    }
                    case "%t": {
                        entries.add(TimestampLogEntry.create());
                        continue block30;
                    }
                    case "%r": {
                        entries.add(RequestLineLogEntry.create());
                        continue block30;
                    }
                    case "%s": {
                        entries.add(StatusLogEntry.create());
                        continue block30;
                    }
                    case "%b": {
                        entries.add(SizeLogEntry.create());
                        continue block30;
                    }
                    case "%D": {
                        entries.add(TimeTakenLogEntry.builder().unit(TimeUnit.MICROSECONDS).build());
                        continue block30;
                    }
                    case "%T": {
                        entries.add(TimeTakenLogEntry.builder().unit(TimeUnit.SECONDS).build());
                        continue block30;
                    }
                    default: {
                        Matcher matcher = HEADER_ENTRY_PATTERN.matcher(formatEntry);
                        if (matcher.matches()) {
                            entries.add(HeaderLogEntry.create(matcher.group(1)));
                            continue block30;
                        }
                        throw new IllegalArgumentException("Unsupported access log format entry: " + format);
                    }
                }
            }
            builder.entries(entries);
        }
    }

    static class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.BuilderMethod
        static void defaultLogFormat(AccessLogConfig.BuilderBase<?, ?> builder) {
            builder.entries(AccessLogConfigBlueprint.HELIDON_FORMAT);
        }

        @Prototype.BuilderMethod
        static void commonLogFormat(AccessLogConfig.BuilderBase<?, ?> builder) {
            builder.entries(AccessLogConfigBlueprint.COMMON_FORMAT);
        }
    }
}

