/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.common.Weighted;
import io.helidon.config.Config;
import io.helidon.webserver.accesslog.AccessLogContext;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.HeaderLogEntry;
import io.helidon.webserver.accesslog.HostLogEntry;
import io.helidon.webserver.accesslog.RequestLineLogEntry;
import io.helidon.webserver.accesslog.SizeLogEntry;
import io.helidon.webserver.accesslog.StatusLogEntry;
import io.helidon.webserver.accesslog.TimeTakenLogEntry;
import io.helidon.webserver.accesslog.TimestampLogEntry;
import io.helidon.webserver.accesslog.UserIdLogEntry;
import io.helidon.webserver.accesslog.UserLogEntry;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AccessLogRoutingFeature
implements HttpFeature,
Weighted {
    public static final String DEFAULT_LOGGER_NAME = "io.helidon.webserver.AccessLog";
    static final String ACCESS_LOG_ID = "access-log";
    static final double WEIGHT = 1000.0;
    private static final Pattern HEADER_ENTRY_PATTERN = Pattern.compile("%\\{(.*?)}i");
    private final List<AccessLogEntry> logFormat;
    private final System.Logger logger;
    private final boolean enabled;
    private final Clock clock;
    private final double weight;

    private AccessLogRoutingFeature(Builder builder) {
        this.enabled = builder.enabled;
        this.logFormat = builder.entries;
        this.clock = builder.clock;
        this.logger = System.getLogger(builder.loggerName);
        this.weight = builder.weight;
    }

    public static AccessLogRoutingFeature create() {
        return AccessLogRoutingFeature.builder().build();
    }

    public static AccessLogRoutingFeature create(Config config) {
        return AccessLogRoutingFeature.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setup(HttpRouting.Builder routing) {
        if (this.enabled) {
            routing.addFilter(this::filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        long nanoNow = System.nanoTime();
        try {
            chain.proceed();
        }
        finally {
            this.log(req, res, now, nanoNow);
        }
    }

    String createLogRecord(final RoutingRequest req, final RoutingResponse res, final ZonedDateTime timeStart, final long nanoStart, final ZonedDateTime timeNow, final long nanoNow) {
        AccessLogContext ctx = new AccessLogContext(){

            @Override
            public long requestNanoTime() {
                return nanoStart;
            }

            @Override
            public long responseNanoTime() {
                return nanoNow;
            }

            @Override
            public ZonedDateTime requestDateTime() {
                return timeStart;
            }

            @Override
            public ZonedDateTime responseDateTime() {
                return timeNow;
            }

            @Override
            public RoutingRequest serverRequest() {
                return req;
            }

            @Override
            public RoutingResponse serverResponse() {
                return res;
            }
        };
        StringBuilder sb = new StringBuilder();
        for (AccessLogEntry entry : this.logFormat) {
            sb.append(entry.apply(ctx));
            sb.append(" ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void log(RoutingRequest req, RoutingResponse res, ZonedDateTime timeStart, long nanoStart) {
        this.logger.log(System.Logger.Level.INFO, this.createLogRecord(req, res, timeStart, nanoStart, ZonedDateTime.now(this.clock), System.nanoTime()));
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, AccessLogRoutingFeature> {
        private static final List<AccessLogEntry> COMMON_FORMAT = List.of(HostLogEntry.create(), UserIdLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create());
        private static final List<AccessLogEntry> HELIDON_FORMAT = List.of(HostLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create(), TimeTakenLogEntry.create());
        private final List<AccessLogEntry> entries = new LinkedList<AccessLogEntry>();
        private Clock clock = Clock.systemDefaultZone();
        private String loggerName = "io.helidon.webserver.AccessLog";
        private boolean enabled = true;
        private double weight = 1000.0;

        private Builder() {
        }

        public AccessLogRoutingFeature build() {
            if (this.entries.isEmpty()) {
                this.defaultLogFormat();
            }
            return new AccessLogRoutingFeature(this);
        }

        public Builder defaultLogFormat() {
            this.entries.clear();
            this.entries.addAll(HELIDON_FORMAT);
            return this;
        }

        public Builder commonLogFormat() {
            this.entries.clear();
            this.entries.addAll(COMMON_FORMAT);
            return this;
        }

        public Builder logFormatString(String format) {
            String[] formatEntries;
            this.entries.clear();
            String[] stringArray = formatEntries = format.split(" ");
            int n = stringArray.length;
            block22: for (int i = 0; i < n; ++i) {
                String formatEntry;
                switch (formatEntry = stringArray[i]) {
                    case "%h": {
                        this.add(HostLogEntry.create());
                        continue block22;
                    }
                    case "%l": {
                        this.add(UserIdLogEntry.create());
                        continue block22;
                    }
                    case "%u": {
                        this.add(UserLogEntry.create());
                        continue block22;
                    }
                    case "%t": {
                        this.add(TimestampLogEntry.create());
                        continue block22;
                    }
                    case "%r": {
                        this.add(RequestLineLogEntry.create());
                        continue block22;
                    }
                    case "%s": {
                        this.add(StatusLogEntry.create());
                        continue block22;
                    }
                    case "%b": {
                        this.add(SizeLogEntry.create());
                        continue block22;
                    }
                    case "%D": {
                        this.add(TimeTakenLogEntry.builder().unit(TimeUnit.MICROSECONDS).build());
                        continue block22;
                    }
                    case "%T": {
                        this.add(TimeTakenLogEntry.builder().unit(TimeUnit.SECONDS).build());
                        continue block22;
                    }
                    default: {
                        Matcher matcher = HEADER_ENTRY_PATTERN.matcher(formatEntry);
                        if (matcher.matches()) {
                            this.add(HeaderLogEntry.create(matcher.group(1)));
                            continue block22;
                        }
                        throw new IllegalArgumentException("Unsupported access log format entry: " + format);
                    }
                }
            }
            return this;
        }

        public Builder add(AccessLogEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("logger-name").asString().ifPresent(this::loggerName);
            config.get("format").asString().ifPresent(this::configLogFormat);
            config.get("weight").asDouble().ifPresent(this::weight);
            return this;
        }

        public Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder loggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        private void configLogFormat(String format) {
            switch (format) {
                case "common": {
                    this.commonLogFormat();
                    break;
                }
                case "default": {
                    this.defaultLogFormat();
                    break;
                }
                default: {
                    this.logFormatString(format);
                }
            }
        }
    }
}

