/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.http.HttpPrologue;
import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;

public final class RequestLineLogEntry
extends AbstractLogEntry {
    private RequestLineLogEntry(Builder builder) {
        super(builder);
    }

    public static RequestLineLogEntry create() {
        return RequestLineLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String doApply(AccessLogContext context) {
        HttpPrologue prologue = context.serverRequest().prologue();
        return "\"" + prologue.method().text() + " " + prologue.uriPath().rawPath() + " " + prologue.protocol() + "/" + prologue.protocolVersion() + "\"";
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<RequestLineLogEntry, Builder> {
        private Builder() {
        }

        public RequestLineLogEntry build() {
            return new RequestLineLogEntry(this);
        }
    }
}

