/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.common.security.SecurityContext;
import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;
import java.security.Principal;
import java.util.Optional;

public final class UserLogEntry
extends AbstractLogEntry {
    private UserLogEntry(Builder builder) {
        super(builder);
    }

    public static UserLogEntry create() {
        return UserLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String doApply(AccessLogContext context) {
        Optional maybeContext = context.serverRequest().context().get(SecurityContext.class);
        if (maybeContext.isEmpty()) {
            return "-";
        }
        SecurityContext securityContext = (SecurityContext)maybeContext.get();
        return securityContext.userPrincipal().map(Principal::getName).orElse("-");
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<UserLogEntry, Builder> {
        private Builder() {
        }

        public UserLogEntry build() {
            return new UserLogEntry(this);
        }
    }
}

