/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.context.ContextFeature;
import io.helidon.webserver.context.ContextFeatureConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.context.ContextFeatureConfigBlueprint")
public interface ContextFeatureConfig
extends ContextFeatureConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContextFeatureConfig instance) {
        return (Builder)ContextFeatureConfig.builder().from(instance);
    }

    public static ContextFeatureConfig create(Config config) {
        return ((Builder)ContextFeatureConfig.builder().config(config)).buildPrototype();
    }

    public static ContextFeatureConfig create() {
        return ContextFeatureConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ContextFeatureConfig>
    implements io.helidon.common.Builder<Builder, ContextFeature> {
        private Builder() {
        }

        public ContextFeatureConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ContextFeatureConfigImpl(this);
        }

        public ContextFeature build() {
            return ContextFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ContextFeatureConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<String> sockets = new LinkedHashSet<String>();
        private Config config;
        private double weight = 1100.0;
        private String name = "context";

        protected BuilderBase() {
        }

        public BUILDER from(ContextFeatureConfig prototype) {
            this.weight(prototype.weight());
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.weight(builder.weight());
            this.addSockets(builder.sockets());
            this.name(builder.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public double weight() {
            return this.weight;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ContextFeatureConfigBuilder{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class ContextFeatureConfigImpl
        implements ContextFeatureConfig,
        Supplier<ContextFeature> {
            private final double weight;
            private final Set<String> sockets;
            private final String name;

            protected ContextFeatureConfigImpl(BuilderBase<?, ?> builder) {
                this.weight = builder.weight();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.name = builder.name();
            }

            public ContextFeature build() {
                return ContextFeature.create(this);
            }

            @Override
            public ContextFeature get() {
                return this.build();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "ContextFeatureConfig{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContextFeatureConfig)) {
                    return false;
                }
                ContextFeatureConfig other = (ContextFeatureConfig)o;
                return this.weight == other.weight() && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.weight, this.sockets, this.name);
            }
        }
    }
}

