/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.json;

import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ContentReaders;
import io.helidon.webserver.ContentWriters;
import io.helidon.webserver.Handler;
import io.helidon.webserver.MediaType;
import io.helidon.webserver.Parameters;
import io.helidon.webserver.ResponseChunk;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public final class JsonSupport
implements Service,
Handler {
    private static final MediaType APPLICATION_JAVASCRIPT = new MediaType("application", "javascript");
    private final JsonReaderFactory jsonReaderFactory;
    private final JsonWriterFactory jsonWriterFactory;

    private JsonSupport(Map<String, ?> config) {
        this.jsonReaderFactory = Json.createReaderFactory(config);
        this.jsonWriterFactory = Json.createWriterFactory(config);
    }

    public void update(Routing.Rules routingRules) {
        routingRules.any(new Handler[]{this});
    }

    public void accept(ServerRequest request, ServerResponse response) {
        request.content().registerReader(JsonStructure.class::isAssignableFrom, (publisher, type) -> {
            Charset charset = this.determineCharset((Parameters)request.headers());
            return this.reader(charset).apply(publisher);
        });
        response.registerWriter(json -> json instanceof JsonStructure && this.testOrSetContentType(request, response), json -> {
            Charset charset = this.determineCharset((Parameters)response.headers());
            return this.writer(charset).apply((JsonStructure)json);
        });
        request.next();
    }

    private boolean testOrSetContentType(ServerRequest request, ServerResponse response) {
        MediaType mt = response.headers().contentType().orElse(null);
        if (mt == null) {
            List acceptedTypes = request.headers().acceptedTypes();
            MediaType preferredType = acceptedTypes.isEmpty() ? MediaType.APPLICATION_JSON : (MediaType)acceptedTypes.stream().map(type -> {
                if (type.test(MediaType.APPLICATION_JSON)) {
                    return MediaType.APPLICATION_JSON;
                }
                if (type.test(APPLICATION_JAVASCRIPT)) {
                    return APPLICATION_JAVASCRIPT;
                }
                if (type.hasSuffix("json")) {
                    return new MediaType(type.getType(), type.getSubtype());
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
            if (preferredType == null) {
                return false;
            }
            response.headers().contentType(preferredType);
            return true;
        }
        return MediaType.JSON_PREDICATE.test(mt);
    }

    private Charset determineCharset(Parameters headers) {
        return headers.first("Content-Type").map(MediaType::parse).flatMap(MediaType::getCharset).map(sch -> {
            try {
                return Charset.forName(sch);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(null);
    }

    public ServerRequest.Reader<JsonStructure> reader(Charset charset) {
        return (publisher, clazz) -> ContentReaders.byteArrayReader().apply(publisher).thenApply(bytes -> {
            JsonReader reader = charset == null ? this.jsonReaderFactory.createReader((InputStream)new ByteArrayInputStream((byte[])bytes)) : this.jsonReaderFactory.createReader((InputStream)new ByteArrayInputStream((byte[])bytes), charset);
            return reader.read();
        });
    }

    public ServerRequest.Reader<JsonStructure> reader() {
        return this.reader(null);
    }

    public Function<JsonStructure, Flow.Publisher<ResponseChunk>> writer(Charset charset) {
        return json -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = charset == null ? this.jsonWriterFactory.createWriter((OutputStream)baos) : this.jsonWriterFactory.createWriter((OutputStream)baos, charset);
            writer.write(json);
            writer.close();
            return (Flow.Publisher)ContentWriters.byteArrayWriter((boolean)false).apply(baos.toByteArray());
        };
    }

    public Function<JsonStructure, Flow.Publisher<ResponseChunk>> writer() {
        return this.writer(null);
    }

    public static JsonSupport get() {
        return DefaultJsonSupportHolder.INTANCE;
    }

    public static JsonSupport create(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return JsonSupport.get();
        }
        return new JsonSupport(config);
    }

    private static final class DefaultJsonSupportHolder {
        private static final JsonSupport INTANCE = new JsonSupport(null);

        private DefaultJsonSupportHolder() {
        }
    }
}

