/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.context.Contexts;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.Security;
import io.helidon.webserver.security.SecurityFeatureConfig;
import io.helidon.webserver.security.SecurityHandlerConfig;
import java.util.Optional;

class SecurityConfigSupport {
    private SecurityConfigSupport() {
    }

    static class SecurityHandlerDecorator
    implements Prototype.BuilderDecorator<SecurityHandlerConfig.BuilderBase<?, ?>> {
        SecurityHandlerDecorator() {
        }

        public void decorate(SecurityHandlerConfig.BuilderBase<?, ?> builder) {
            if (!builder.rolesAllowed().isEmpty()) {
                if (builder.authenticate().isEmpty()) {
                    builder.authenticate(true);
                }
                if (builder.authorize().isEmpty()) {
                    builder.authorize(true);
                }
            }
            if (builder.authenticationOptional().orElse(false).booleanValue() && builder.authenticate().isEmpty()) {
                builder.authenticate(true);
            }
            if (builder.authenticator().isPresent() && builder.authenticate().isEmpty()) {
                builder.authenticate(true);
            }
            if (builder.authorizer().isPresent() && builder.authorize().isEmpty()) {
                builder.authorize(true);
            }
            if (builder.auditEventType().isPresent() && builder.audit().isEmpty()) {
                builder.audit(true);
            }
            if (builder.auditMessageFormat().isPresent() && builder.audit().isEmpty()) {
                builder.audit(true);
            }
        }
    }

    static class SecurityHandlerCustomMethods {
        private SecurityHandlerCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void addObject(SecurityHandlerConfig.BuilderBase<?, ?> builder, Object object) {
            Optional<ClassToInstanceStore<Object>> objects = builder.customObjects();
            if (objects.isEmpty()) {
                builder.customObjects((ClassToInstanceStore<Object>)ClassToInstanceStore.create((Object[])new Object[]{object}));
            } else {
                objects.get().putInstance(object);
            }
        }

        @Prototype.BuilderMethod
        static void addObject(SecurityHandlerConfig.BuilderBase<?, ?> builder, Class<?> objectType, Object object) {
            ClassToInstanceStore<Object> store;
            Optional<ClassToInstanceStore<Object>> objects = builder.customObjects();
            if (objects.isEmpty()) {
                store = ClassToInstanceStore.create((Object[])new Object[0]);
                builder.customObjects(store);
            } else {
                store = objects.get();
            }
            store.putInstance(objectType, object);
        }
    }

    static class SecurityFeatureConfigDecorator
    implements Prototype.BuilderDecorator<SecurityFeatureConfig.BuilderBase<?, ?>> {
        private static final System.Logger LOGGER = System.getLogger(SecurityFeatureConfig.class.getName());

        SecurityFeatureConfigDecorator() {
        }

        public void decorate(SecurityFeatureConfig.BuilderBase<?, ?> target) {
            this.security(target);
            this.oldSetup(target);
        }

        private void oldSetup(SecurityFeatureConfig.BuilderBase<?, ?> target) {
            Config config;
            if (!target.paths().isEmpty()) {
                return;
            }
            Optional<Config> configOnBuilder = target.config();
            if (configOnBuilder.isPresent() && (config = configOnBuilder.get().root().get("security.web-server")).exists()) {
                LOGGER.log(System.Logger.Level.WARNING, "Configuration key security.web-server is deprecated, please configure security integration with webserver under server.features.security instead");
                target.config(config);
            }
        }

        private void security(SecurityFeatureConfig.BuilderBase<?, ?> target) {
            Optional security = target.security();
            if (security.isPresent()) {
                return;
            }
            security = Contexts.globalContext().get(Security.class);
            if (security.isPresent()) {
                target.security((Security)security.get());
                return;
            }
            Optional<Config> config = target.config();
            if (config.isEmpty()) {
                throw new ConfigException("SecurityFeature requires either a configured Security, or security registered with global context, or configuration instance to construct security");
            }
            Security newSecurity = Security.create((Config)config.get().root().get("security"));
            target.security(newSecurity);
        }
    }
}

