/*
 * Copyright (c) 2023 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webserver.security;

import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.webserver.spi.ServerFeatureProvider;

/**
 * {@link java.util.ServiceLoader} provider implementation of {@link io.helidon.webserver.spi.ServerFeatureProvider}
 * for security.
 */
@Weight(SecurityFeature.WEIGHT)
public class SecurityFeatureProvider implements ServerFeatureProvider<SecurityFeature> {
    @Override
    public String configKey() {
        return SecurityFeature.SECURITY_ID;
    }

    @Override
    public SecurityFeature create(Config config, String name) {
        return SecurityFeature.builder()
                .name(name)
                .config(config)
                .build();
    }
}
