/*
 * Copyright (c) 2022, 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Helidon WebServer Security Support.
 */
module io.helidon.webserver.security {
    requires io.helidon.common.context;
    requires io.helidon.security.integration.common;
    requires io.helidon.webserver;

    requires transitive io.helidon.builder.api;
    requires transitive io.helidon.common;
    requires transitive io.helidon.common.config;
    requires transitive io.helidon.security.util;
    requires transitive io.helidon.security;

    provides io.helidon.webserver.spi.ServerFeatureProvider
            with io.helidon.webserver.security.SecurityFeatureProvider;

    exports io.helidon.webserver.security;

}
