/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.http.Http;
import io.helidon.webserver.WebServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.logging.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringEndsWith;

public class SocketHttpClient
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(SocketHttpClient.class.getName());
    private final Socket socket;

    public SocketHttpClient(WebServer webServer) throws IOException {
        this.socket = new Socket(InetAddress.getLocalHost(), webServer.port());
    }

    public static String sendAndReceive(Http.Method method, String payload, WebServer webServer) throws Exception {
        return SocketHttpClient.sendAndReceive("/", method, payload, webServer);
    }

    public static String sendAndReceive(String path, Http.Method method, String payload, WebServer webServer) throws Exception {
        return SocketHttpClient.sendAndReceive(path, method, payload, Collections.emptyList(), webServer);
    }

    public static String sendAndReceive(String path, Http.Method method, String payload, Iterable<String> headers, WebServer webServer) throws Exception {
        try (SocketHttpClient s = new SocketHttpClient(webServer);){
            s.request(method, path, payload, headers);
            String string = s.receive();
            return string;
        }
    }

    public static void assertConnectionIsOpen(SocketHttpClient s) throws IOException {
        s.request(Http.Method.GET);
        MatcherAssert.assertThat((Object)s.receive(), (Matcher)StringEndsWith.endsWith((String)"\n9\nIt works!\n0\n\n"));
    }

    public static void assertConnectionIsClosed(SocketHttpClient s) throws IOException {
        s.request(Http.Method.POST, null);
        try {
            MatcherAssert.assertThat((Object)s.receive(), (Matcher)Is.is((Object)""));
        }
        catch (SocketException e) {
            LOGGER.finer("Received: " + e.getMessage());
        }
    }

    public static StringBuilder longData(int bytes) {
        StringBuilder data = new StringBuilder(bytes);
        int i = 0;
        while (data.length() < bytes) {
            data.append(i).append("\n");
            ++i;
        }
        return data;
    }

    public String receive() throws IOException {
        String t;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        boolean ending = false;
        while ((t = br.readLine()) != null) {
            LOGGER.finest("Received: " + t);
            sb.append(t).append("\n");
            if (ending && "".equalsIgnoreCase(t)) break;
            if (!ending && "0".equalsIgnoreCase(t)) {
                ending = true;
                continue;
            }
            ending = false;
        }
        return sb.toString();
    }

    public void request(Http.Method method) throws IOException {
        this.request(method, null);
    }

    public void request(Http.Method method, String payload) throws IOException {
        this.request(method, "/", payload);
    }

    public void request(Http.Method method, String path, String payload) throws IOException {
        this.request(method, path, payload, CollectionsHelper.listOf((Object[])new String[]{"Content-Type: application/x-www-form-urlencoded"}));
    }

    public void request(Http.Method method, String path, String payload, Iterable<String> headers) throws IOException {
        if (headers == null) {
            headers = Collections.emptyList();
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
        pw.print(method.name());
        pw.print(" ");
        pw.print(path);
        pw.println(" HTTP/1.1");
        pw.println("Host: 127.0.0.1");
        for (String header : headers) {
            pw.println(header);
        }
        this.sendPayload(pw, payload);
        pw.println("");
        pw.flush();
    }

    protected void sendPayload(PrintWriter pw, String payload) {
        if (payload != null) {
            pw.println("Content-Length: " + payload.length());
            pw.println("");
            pw.println(payload);
        }
    }

    @Override
    public void close() throws Exception {
        this.socket.close();
    }
}

