/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.http.Http;
import io.helidon.webserver.testsupport.MediaPublisher;
import io.helidon.webserver.testsupport.TestClient;
import io.helidon.webserver.testsupport.TestResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class TestRequest {
    private final TestClient testClient;
    private final String path;
    private final StringBuilder query = new StringBuilder();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private volatile Http.Version version = Http.Version.V1_1;

    TestRequest(TestClient testClient, String path) {
        this.testClient = testClient;
        if (path == null) {
            path = "/";
        } else if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        int ind = ((String)path).indexOf(63);
        if (ind > 0) {
            this.query.append(((String)path).substring(ind + 1));
            path = ((String)path).substring(0, ind);
        }
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestRequest queryParameter(String name, String value) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        Objects.requireNonNull(name, "Parameter 'value' is null!");
        StringBuilder stringBuilder = this.query;
        synchronized (stringBuilder) {
            if (this.query.length() == 0) {
                this.query.append('?');
            } else {
                this.query.append('&');
            }
            this.query.append(this.encode(name)).append('=').append(this.encode(value));
        }
        return this;
    }

    public TestRequest header(String name, String value) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        Objects.requireNonNull(name, "Parameter 'value' is null!");
        this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
        return this;
    }

    public TestRequest version(Http.Version version) {
        Objects.requireNonNull(version, "Parameter 'version' is null!");
        this.version = version;
        return this;
    }

    private URI uri() {
        return URI.create(this.path + this.query);
    }

    public TestResponse get(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.GET, mediaPublisher);
    }

    public TestResponse get() throws InterruptedException, TimeoutException {
        return this.get(null);
    }

    public TestResponse post(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.POST, mediaPublisher);
    }

    public TestResponse post() throws InterruptedException, TimeoutException {
        return this.post(null);
    }

    public TestResponse put(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.PUT, mediaPublisher);
    }

    public TestResponse put() throws InterruptedException, TimeoutException {
        return this.put(null);
    }

    public TestResponse delete(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.DELETE, mediaPublisher);
    }

    public TestResponse delete() throws InterruptedException, TimeoutException {
        return this.delete(null);
    }

    public TestResponse options(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.OPTIONS, mediaPublisher);
    }

    public TestResponse options() throws InterruptedException, TimeoutException {
        return this.options(null);
    }

    public TestResponse head(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.HEAD, mediaPublisher);
    }

    public TestResponse head() throws InterruptedException, TimeoutException {
        return this.head(null);
    }

    public TestResponse trace(MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        return this.call((Http.RequestMethod)Http.Method.TRACE, mediaPublisher);
    }

    public TestResponse trace() throws InterruptedException, TimeoutException {
        return this.trace(null);
    }

    public TestResponse call(Http.RequestMethod method, MediaPublisher mediaPublisher) throws InterruptedException, TimeoutException {
        if (mediaPublisher != null && !this.headers.containsKey("Content-Type") && mediaPublisher.mediaType() != null) {
            this.header("Content-Type", mediaPublisher.mediaType().toString());
        }
        return this.testClient.call(method, this.version, this.uri(), this.headers, mediaPublisher);
    }

    public TestResponse call(Http.RequestMethod method) throws InterruptedException, TimeoutException {
        return this.testClient.call(method, this.version, this.uri(), this.headers, null);
    }

    private String encode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is not supported!", e);
        }
    }
}

