/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.StaticContentHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.logging.Logger;

class FileSystemContentHandler
extends StaticContentHandler {
    private static final Logger LOGGER = Logger.getLogger(FileSystemContentHandler.class.getName());
    private final Path root;

    FileSystemContentHandler(String welcomeFilename, ContentTypeSelector contentTypeSelector, Path root) {
        super(welcomeFilename, contentTypeSelector);
        this.root = root.toAbsolutePath().normalize();
    }

    public static StaticContentHandler create(String welcomeFileName, ContentTypeSelector selector, Path fsRoot) {
        if (Files.exists(fsRoot, new LinkOption[0]) && Files.isDirectory(fsRoot, new LinkOption[0])) {
            return new FileSystemContentHandler(welcomeFileName, selector, fsRoot);
        }
        throw new IllegalArgumentException("Cannot create file system static content, path " + fsRoot.toAbsolutePath() + " does not exist or is not a directory");
    }

    @Override
    boolean doHandle(Http.RequestMethod method, String requestedPath, ServerRequest request, ServerResponse response) throws IOException {
        Path resolved;
        if (requestedPath.isEmpty()) {
            resolved = this.root;
        } else {
            resolved = this.root.resolve(Paths.get(requestedPath, new String[0])).normalize();
            LOGGER.finest(() -> "Requested file: " + resolved.toAbsolutePath());
            if (!resolved.startsWith(this.root)) {
                return false;
            }
        }
        return this.doHandle(method, resolved, request, response);
    }

    boolean doHandle(Http.RequestMethod method, Path path, ServerRequest request, ServerResponse response) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        FileSystemContentHandler.sendFile(method, path, request, response, this.contentTypeSelector(), this.welcomePageName());
        return true;
    }

    static void sendFile(Http.RequestMethod method, Path path, ServerRequest request, ServerResponse response, ContentTypeSelector contentTypeSelector, String welcomePage) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            String rawFullPath = request.uri().getRawPath();
            if (rawFullPath.endsWith("/")) {
                path = FileSystemContentHandler.resolveWelcomeFile(path, welcomePage);
            } else {
                FileSystemContentHandler.redirect(response, rawFullPath + "/");
                return;
            }
        }
        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path) || Files.isHidden(path)) {
            throw new HttpException("File is not accessible", (Http.ResponseStatus)Http.Status.FORBIDDEN_403);
        }
        try {
            Instant lastMod = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
            FileSystemContentHandler.processEtag(String.valueOf(lastMod.toEpochMilli()), request.headers(), response.headers());
            FileSystemContentHandler.processModifyHeaders(lastMod, request.headers(), response.headers());
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        FileSystemContentHandler.processContentType(FileSystemContentHandler.fileName(path), request.headers(), response.headers(), contentTypeSelector);
        if (method == Http.Method.HEAD) {
            response.send();
        } else {
            response.send(path);
        }
    }

    private static Path resolveWelcomeFile(Path directory, String name) {
        FileSystemContentHandler.throwNotFoundIf(name == null || name.isEmpty());
        Path result = directory.resolve(name);
        FileSystemContentHandler.throwNotFoundIf(!Files.exists(result, new LinkOption[0]));
        return result;
    }
}

