/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.webserver.ErrorHandler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface Handler
extends BiConsumer<ServerRequest, ServerResponse> {
    @Override
    public void accept(ServerRequest var1, ServerResponse var2);

    public static <T> Handler create(Class<T> entityType, EntityHandler<T> entityHandler) {
        return Handler.create(entityType, entityHandler, null);
    }

    public static <T> Handler create(Class<T> entityType, EntityHandler<T> entityHandler, ErrorHandler<Throwable> entityReadErrorHandler) {
        Objects.requireNonNull(entityType, "Parameter 'publisherType' is null!");
        Objects.requireNonNull(entityHandler, "Parameter 'entityHandler' is null!");
        return (req, res) -> {
            CompletionStage cs;
            Optional context = Contexts.context();
            try {
                cs = req.content().as(entityType);
            }
            catch (Throwable thr) {
                if (entityReadErrorHandler == null) {
                    req.next(thr);
                } else {
                    entityReadErrorHandler.accept(req, res, thr);
                }
                return;
            }
            cs.thenAccept(entity -> context.ifPresentOrElse(theContext -> Contexts.runInContext((Context)theContext, () -> entityHandler.accept(req, res, entity)), () -> entityHandler.accept(req, res, entity))).exceptionally(throwable -> {
                if (entityReadErrorHandler == null) {
                    req.next(throwable instanceof CompletionException ? throwable.getCause() : throwable);
                } else {
                    entityReadErrorHandler.accept(req, res, (Throwable)throwable);
                }
                return null;
            });
        };
    }

    @FunctionalInterface
    public static interface EntityHandler<T> {
        public void accept(ServerRequest var1, ServerResponse var2, T var3);
    }
}

