/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.OriginThreadPublisher;
import io.helidon.webserver.ByteBufRequestChunk;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

class HttpRequestScopedPublisher
extends OriginThreadPublisher<DataChunk, ByteBuf> {
    private static final Logger LOGGER = Logger.getLogger(HttpRequestScopedPublisher.class.getName());
    private volatile boolean suspended = false;
    private final ChannelHandlerContext ctx;
    private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();
    private final ReferenceHoldingQueue<DataChunk> referenceQueue;

    HttpRequestScopedPublisher(ChannelHandlerContext ctx, ReferenceHoldingQueue<DataChunk> referenceQueue) {
        this.referenceQueue = referenceQueue;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookOnRequested(long n, long result) {
        if (result == Long.MAX_VALUE) {
            LOGGER.finest("Netty autoread: true");
            this.ctx.channel().config().setAutoRead(true);
        } else {
            LOGGER.finest("Netty autoread: false");
            this.ctx.channel().config().setAutoRead(false);
        }
        try {
            this.lock.lock();
            if (this.suspended && super.tryAcquire() > 0L) {
                this.suspended = false;
                LOGGER.finest("Requesting next chunks from Netty.");
                this.ctx.channel().read();
            } else {
                LOGGER.finest("No hook action required.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryAcquire() {
        try {
            this.lock.lock();
            long l = super.tryAcquire();
            if (l <= 0L) {
                this.suspended = true;
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void submit(ByteBuf data) {
        try {
            super.submit((Object)data);
        }
        finally {
            this.referenceQueue.release();
        }
    }

    public void complete() {
        try {
            super.complete();
        }
        finally {
            this.referenceQueue.release();
        }
    }

    public void error(Throwable throwable) {
        try {
            super.error(throwable);
        }
        finally {
            this.referenceQueue.release();
        }
    }

    protected DataChunk wrap(ByteBuf data) {
        return new ByteBufRequestChunk(data, this.referenceQueue);
    }

    protected void drain(DataChunk item) {
        item.release();
    }
}

