/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.media.common.MessageBodyFilter;
import io.helidon.media.common.MessageBodyFilters;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.common.MessageBodyWriters;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.WebServer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ServerResponse
extends MessageBodyFilters,
MessageBodyWriters {
    public WebServer webServer();

    public Http.ResponseStatus status();

    default public ServerResponse status(int statusCode) throws AlreadyCompletedException {
        return this.status(Http.ResponseStatus.create((int)statusCode));
    }

    public ServerResponse status(Http.ResponseStatus var1) throws AlreadyCompletedException, NullPointerException;

    public ResponseHeaders headers();

    public MessageBodyWriterContext writerContext();

    public Void send(Throwable var1);

    public <T> CompletionStage<ServerResponse> send(T var1);

    public <T> CompletionStage<ServerResponse> send(Flow.Publisher<T> var1, Class<T> var2);

    public CompletionStage<ServerResponse> send(Flow.Publisher<DataChunk> var1);

    public CompletionStage<ServerResponse> send();

    @Deprecated
    public <T> ServerResponse registerWriter(Class<T> var1, Function<T, Flow.Publisher<DataChunk>> var2);

    @Deprecated
    public <T> ServerResponse registerWriter(Class<T> var1, MediaType var2, Function<? extends T, Flow.Publisher<DataChunk>> var3);

    @Deprecated
    public <T> ServerResponse registerWriter(Predicate<?> var1, Function<T, Flow.Publisher<DataChunk>> var2);

    @Deprecated
    public <T> ServerResponse registerWriter(Predicate<?> var1, MediaType var2, Function<T, Flow.Publisher<DataChunk>> var3);

    @Deprecated
    public ServerResponse registerFilter(Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> var1);

    public ServerResponse registerFilter(MessageBodyFilter var1);

    public ServerResponse registerWriter(MessageBodyWriter<?> var1);

    public ServerResponse registerWriter(MessageBodyStreamWriter<?> var1);

    public CompletionStage<ServerResponse> whenSent();

    public long requestId();
}

