/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.http.ContextualRegistry;
import io.helidon.media.common.MediaSupport;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.RequestRouting;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface WebServer {
    public ServerConfiguration configuration();

    public CompletionStage<WebServer> start();

    public CompletionStage<WebServer> whenShutdown();

    public CompletionStage<WebServer> shutdown();

    public boolean isRunning();

    public ContextualRegistry context();

    public MediaSupport mediaSupport();

    default public int port() {
        return this.port("@default");
    }

    public int port(String var1);

    public static WebServer create(Supplier<? extends ServerConfiguration> configurationBuilder, Routing routing) {
        return WebServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routing);
    }

    public static WebServer create(Supplier<? extends ServerConfiguration> configurationBuilder, Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routingBuilder.get());
    }

    public static WebServer create(ServerConfiguration configuration, Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configuration, routingBuilder.get());
    }

    public static WebServer create(Routing routing) {
        return WebServer.create((ServerConfiguration)null, routing);
    }

    public static WebServer create(ServerConfiguration configuration, Routing routing) {
        Objects.requireNonNull(routing, "Parameter 'routing' is null!");
        return WebServer.builder(routing).config(configuration).build();
    }

    public static WebServer create(Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(routingBuilder.get());
    }

    public static Builder builder(Supplier<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.builder(routingBuilder.get());
    }

    public static Builder builder(Routing routing) {
        return new Builder(routing);
    }

    public static final class Builder
    implements io.helidon.common.Builder<WebServer> {
        private final Map<String, Routing> routings = new HashMap<String, Routing>();
        private final Routing defaultRouting;
        private ServerConfiguration configuration;
        private MediaSupport mediaSupport;

        private Builder(Routing defaultRouting) {
            Objects.requireNonNull(defaultRouting, "Parameter 'default routing' must not be null!");
            this.defaultRouting = defaultRouting;
        }

        public Builder config(ServerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder config(Supplier<ServerConfiguration> configurationBuilder) {
            this.configuration = configurationBuilder != null ? configurationBuilder.get() : null;
            return this;
        }

        public Builder addNamedRouting(String name, Routing routing) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routing, "Parameter 'routing' must not be null!");
            this.routings.put(name, routing);
            return this;
        }

        public Builder addNamedRouting(String name, Supplier<Routing> routingBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
            return this.addNamedRouting(name, routingBuilder.get());
        }

        public Builder mediaSupport(MediaSupport mediaSupport) {
            this.mediaSupport = mediaSupport;
            return this;
        }

        public Builder mediaSupport(Supplier<MediaSupport> mediaSupportBuilder) {
            this.mediaSupport = mediaSupportBuilder != null ? mediaSupportBuilder.get() : null;
            return this;
        }

        public WebServer build() {
            String unpairedRoutings = this.routings.keySet().stream().filter(routingName -> this.configuration == null || this.configuration.socket((String)routingName) == null).collect(Collectors.joining(", "));
            if (!unpairedRoutings.isEmpty()) {
                throw new IllegalStateException("No server socket configuration found for named routings: " + unpairedRoutings);
            }
            if (this.mediaSupport == null) {
                this.mediaSupport = MediaSupport.createWithDefaults();
            }
            NettyWebServer result = new NettyWebServer(this.configuration == null ? ServerConfiguration.builder().build() : this.configuration, this.defaultRouting, this.routings, this.mediaSupport);
            if (this.defaultRouting instanceof RequestRouting) {
                ((RequestRouting)this.defaultRouting).fireNewWebServer(result);
            }
            return result;
        }

        static {
            HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"WebServer"});
        }
    }
}

