/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.MediaType;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.List;

public abstract class JsonService
implements Service,
Handler {
    @Override
    public void update(Routing.Rules routingRules) {
        routingRules.any(this);
    }

    protected boolean acceptsJson(ServerRequest request, ServerResponse response) {
        MediaType responseType = response.headers().contentType().orElse(null);
        if (responseType == null) {
            MediaType jsonResponseType = this.toJsonResponseType(request.headers().acceptedTypes());
            if (jsonResponseType == null) {
                return false;
            }
            response.headers().contentType(jsonResponseType);
            return true;
        }
        return MediaType.JSON_PREDICATE.test(responseType);
    }

    private MediaType toJsonResponseType(List<MediaType> acceptedTypes) {
        if (acceptedTypes == null || acceptedTypes.isEmpty()) {
            return MediaType.APPLICATION_JSON;
        }
        for (MediaType type : acceptedTypes) {
            MediaType responseType = this.toJsonResponseType(type);
            if (responseType == null) continue;
            return responseType;
        }
        return null;
    }

    protected MediaType toJsonResponseType(MediaType acceptedType) {
        if (acceptedType.test(MediaType.APPLICATION_JSON)) {
            return MediaType.APPLICATION_JSON;
        }
        if (acceptedType.hasSuffix("json")) {
            return MediaType.create((String)acceptedType.type(), (String)acceptedType.subtype());
        }
        return null;
    }
}

