/*
 * Decompiled with CFR 0.152.
 */
package io.helixservice.feature.configuration.dynamo;

import io.helixservice.core.component.Component;
import io.helixservice.core.feature.AbstractFeature;
import io.helixservice.feature.configuration.ConfigProperty;
import io.helixservice.feature.configuration.dynamo.DynamoConfigResourceLocator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoConfigFeature
extends AbstractFeature {
    private static Logger LOG = LoggerFactory.getLogger(DynamoConfigFeature.class);

    public DynamoConfigFeature() {
        ConfigProperty dynamoConfigEnabled = new ConfigProperty("dynamo.config.enabled", "true");
        if (dynamoConfigEnabled.isTrue()) {
            LOG.info("DynamoDB Configuration feature is enabled");
            String clientEndpoint = new ConfigProperty("dynamo.config.client.endpoint").getValue();
            String accessKey = Optional.ofNullable(System.getenv("AWS_ACCESS_KEY_ID")).orElse(new ConfigProperty("dynamo.config.access.key", "").getValue());
            String secretKey = Optional.ofNullable(System.getenv("AWS_SECRET_ACCESS_KEY")).orElse(new ConfigProperty("dynamo.config.secret.key", "").getValue());
            String tableName = new ConfigProperty("dynamo.config.table.name", "ServiceConfiguration").getValue();
            String serviceName = new ConfigProperty("dynamo.config.service.name", "default").getValue();
            boolean createTable = new ConfigProperty("dynamo.config.create.table", "true").isTrue();
            this.register(new Component[]{new DynamoConfigResourceLocator(clientEndpoint, accessKey, secretKey, tableName, serviceName, createTable)});
        } else {
            LOG.warn("DynamoDB Configuration feature is disabled, because dynamo.config.enabled=" + dynamoConfigEnabled.getValue());
        }
    }

    public DynamoConfigFeature(String clientEndpoint, String accessKey, String secretKey, String tableName, String serviceName, boolean createTable) {
        this.register(new Component[]{new DynamoConfigResourceLocator(clientEndpoint, accessKey, secretKey, tableName, serviceName, createTable)});
    }
}

