/*
 * Decompiled with CFR 0.152.
 */
package io.helixservice.feature.configuration.dynamo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONObject;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.helixservice.feature.configuration.locator.AbstractResourceLocator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoConfigResourceLocator
extends AbstractResourceLocator {
    private static Logger LOG = LoggerFactory.getLogger(DynamoConfigResourceLocator.class);
    private static final String APPLICATION_YAML_FILE = "/application.yml";
    private final String clientEndpoint;
    private final String accessKey;
    private final String secretKey;
    private final String tableName;
    private final String serviceName;
    private AmazonDynamoDBClient client;
    private Table configTable;

    public DynamoConfigResourceLocator(String clientEndpoint, String accessKey, String secretKey, String tableName, String serviceName, boolean createTable) {
        Objects.requireNonNull(clientEndpoint, "clientEndpoint cannot be null");
        Objects.requireNonNull(tableName, "tableName cannot be null");
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        this.clientEndpoint = clientEndpoint;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.tableName = tableName;
        this.serviceName = serviceName;
        this.configureDynamoConnection();
        if (createTable) {
            this.createTable();
        }
    }

    private void configureDynamoConnection() {
        if (!StringUtils.isNullOrEmpty((String)this.accessKey) && !StringUtils.isNullOrEmpty((String)this.secretKey)) {
            System.setProperty("aws.accessKeyId", this.accessKey);
            System.setProperty("aws.secretKey", this.secretKey);
            LOG.info("accessKeyId and secretKey passed successfully via configuration");
        } else {
            LOG.error("accessKeyId or secretKey not set");
        }
        this.client = (AmazonDynamoDBClient)new AmazonDynamoDBClient().withEndpoint(this.clientEndpoint);
        this.configTable = new DynamoDB((AmazonDynamoDB)this.client).getTable(this.tableName);
    }

    private void createTable() {
        try {
            this.client.describeTable(this.tableName);
        }
        catch (ResourceNotFoundException e) {
            ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
            attributeDefinitions.add(new AttributeDefinition().withAttributeName("environment").withAttributeType(ScalarAttributeType.S));
            attributeDefinitions.add(new AttributeDefinition().withAttributeName("service").withAttributeType(ScalarAttributeType.S));
            ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
            keySchema.add(new KeySchemaElement().withAttributeName("environment").withKeyType(KeyType.HASH));
            keySchema.add(new KeySchemaElement().withAttributeName("service").withKeyType(KeyType.RANGE));
            ProvisionedThroughput provisioning = new ProvisionedThroughput(Long.valueOf(8L), Long.valueOf(4L));
            CreateTableRequest createTableRequest = new CreateTableRequest(attributeDefinitions, this.tableName, keySchema, provisioning);
            this.client.createTable(createTableRequest);
        }
    }

    public Optional<InputStream> getStream(String resourcePath) {
        Optional<InputStream> result = Optional.empty();
        if (resourcePath.endsWith(APPLICATION_YAML_FILE)) {
            result = this.getPropertiesFromDynamoDB(resourcePath, result);
        }
        return result;
    }

    private Optional<InputStream> getPropertiesFromDynamoDB(String resourcePath, Optional<InputStream> pResult) {
        Optional<InputStream> result = pResult;
        String environmentName = resourcePath.substring(0, resourcePath.lastIndexOf(APPLICATION_YAML_FILE));
        try {
            Item item = this.configTable.getItem("environment", (Object)environmentName, "service", (Object)this.serviceName);
            if (item == null) {
                LOG.info("No configuration found for environment=" + environmentName + "; creating default empty configuration");
                this.createEmptyConfiguration(environmentName);
            } else {
                String json = item.toJSON();
                JSONObject jsonObject = new JSONObject(json);
                JSONObject config = jsonObject.getJSONObject("config");
                ObjectMapper objectMapper = new ObjectMapper();
                Map mapOfValues = (Map)objectMapper.readValue(config.toString(), Map.class);
                ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                String yamlResult = yamlObjectMapper.writeValueAsString((Object)mapOfValues);
                result = Optional.of(new StringInputStream(yamlResult));
            }
        }
        catch (Throwable t) {
            LOG.error("Unable to load configuration from DynamoDB for environment=" + environmentName, t);
        }
        return result;
    }

    private void createEmptyConfiguration(String environmentName) {
        try {
            Item item = new Item();
            item.withString("environment", environmentName);
            item.withString("service", this.serviceName);
            item.withJSON("config", "{}");
            this.configTable.putItem(item);
            LOG.info("Created default configuration in DynamoDB for environment=" + environmentName);
        }
        catch (Throwable t) {
            LOG.error("Unable to create default configuration in DynamoDB for environment=" + environmentName, t);
        }
    }

    public String getBasePath() {
        return "dynamodbconfig://";
    }

    public String getComponentDescription() {
        return "DynamoDB Config Resource Locator";
    }
}

