/*
 * Decompiled with CFR 0.152.
 */
package io.highlight.sdk.common.record;

import io.highlight.sdk.common.HighlightSessionId;
import io.highlight.sdk.common.record.HighlightErrorRecord;
import io.highlight.sdk.common.record.HighlightLogRecord;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.time.Instant;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class HighlightRecord {
    private final Instant timeOccured;
    private final Attributes attributes;
    private final HighlightSessionId userSession;
    private final String requestId;

    public static HighlightErrorRecord.Builder error() {
        return new HighlightErrorRecord.Builder();
    }

    public static HighlightErrorRecord.Builder error(HighlightErrorRecord record) {
        return new HighlightErrorRecord.Builder(record);
    }

    public static HighlightLogRecord.Builder log() {
        return new HighlightLogRecord.Builder();
    }

    public static HighlightLogRecord.Builder log(HighlightLogRecord record) {
        return new HighlightLogRecord.Builder(record);
    }

    HighlightRecord(Instant timeOccured, Attributes attributes, HighlightSessionId userSession, String requestId) {
        this.timeOccured = timeOccured;
        this.attributes = attributes;
        this.userSession = userSession;
        this.requestId = requestId;
    }

    HighlightRecord(HighlightRecord record) {
        this.timeOccured = record.getTimeOccured();
        this.attributes = record.attributes;
        this.userSession = record.userSession;
        this.requestId = record.requestId;
    }

    public Instant getTimeOccured() {
        return this.timeOccured;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public HighlightSessionId getUserSession() {
        return this.userSession;
    }

    public boolean hasUserSession() {
        return this.userSession != null && this.userSession.sessionId() != null;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean hasRequestId() {
        return this.requestId != null;
    }

    public static class Builder<T extends Builder<T>> {
        private Instant timeOccured;
        private AttributesBuilder attributesBuilder = Attributes.builder();
        private HighlightSessionId userSession;
        private String requestId;

        Builder() {
        }

        Builder(HighlightRecord record) {
            this.timeOccured = record.getTimeOccured();
            this.attributesBuilder.putAll(record.getAttributes());
            this.userSession = record.getUserSession();
            this.requestId = record.getRequestId();
        }

        public T timeOccured(Instant timeOccured) {
            this.timeOccured = timeOccured;
            return (T)this;
        }

        public T userSession(String sessionId) {
            return this.userSession(sessionId != null && !sessionId.isBlank() ? () -> sessionId : null);
        }

        public T userSession(HighlightSessionId userSession) {
            this.userSession = userSession;
            return (T)this;
        }

        public T requestId(String requestId) {
            this.requestId = requestId != null && !requestId.isBlank() ? requestId : null;
            return (T)this;
        }

        public T attributes(Consumer<AttributesBuilder> attributes) {
            attributes.accept(this.attributesBuilder);
            return (T)this;
        }

        public HighlightRecord build() {
            if (this.timeOccured == null) {
                this.timeOccured = Instant.now();
            }
            return new HighlightRecord(this.timeOccured, this.attributesBuilder.build(), this.userSession, this.requestId);
        }
    }
}

