/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.decoder.FunctionCascadeParser;
import io.higson.runtime.decoder.ParamCascadeParser;
import io.higson.runtime.model.Type;
import org.apache.commons.lang3.StringUtils;

class DigestElementCodeProcessor {
    private final VersionInterceptor versionInterceptor;

    String preprocess(Type type, String elementCode) {
        switch (type) {
            case PARAMETER: {
                return this.preprocessParameter(elementCode);
            }
            case FUNCTION: {
                return this.preprocessFunction(elementCode);
            }
        }
        return elementCode;
    }

    private String preprocessParameter(String elementCode) {
        if (StringUtils.startsWith(elementCode, "$p")) {
            elementCode = StringUtils.substring(elementCode, 3);
        }
        if (elementCode.contains("[")) {
            ParamCascadeParser parser = new ParamCascadeParser();
            elementCode = parser.parse(elementCode).getParamCode();
        }
        return this.versionInterceptor.decorateParameterUid(elementCode);
    }

    private String preprocessFunction(String elementCode) {
        if (StringUtils.startsWith(elementCode, "$f")) {
            elementCode = StringUtils.substring(elementCode, 3);
        }
        if (elementCode.contains("(") || elementCode.contains("[")) {
            FunctionCascadeParser parser = new FunctionCascadeParser();
            elementCode = parser.parse(elementCode).getFunctionCode();
        }
        return this.versionInterceptor.decorateFunctionUid(elementCode);
    }

    public DigestElementCodeProcessor(VersionInterceptor versionInterceptor) {
        this.versionInterceptor = versionInterceptor;
    }
}

