/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import io.higson.runtime.engine.annotated.annotations.CtxPathParam;
import io.higson.runtime.engine.annotated.annotations.FetchSuggestion;
import io.higson.runtime.engine.core.context.DefaultContext;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.types.date.DateHolder;
import io.higson.runtime.engine.types.date.DateType;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.date.LocalDateType;
import io.higson.runtime.engine.types.datetime.DatetimeHolder;
import io.higson.runtime.engine.types.datetime.DatetimeType;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeType;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.integer.IntegerType;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.engine.types.string.StringType;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.type.BooleanType;
import io.higson.runtime.type.TypesDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HigsonContext
extends DefaultContext {
    private static StringType stringType;
    private static NumberType numberType;
    private static IntegerType integerType;
    private static BooleanType booleanType;
    private static DateType dateType;
    private static DatetimeType datetimeType;
    private static LocalDateType localDateType;
    private static LocalDateTimeType localDateTimeType;
    private static TypeConverter type;
    protected static final Object SKIP_PARENT;

    public HigsonContext(Object ... args) {
        super(args);
    }

    @FetchSuggestion(value="suggester.ctx.set")
    public HigsonContext set(@CtxPathParam String path, Object value) {
        this.with(path, value);
        return this;
    }

    @Override
    @FetchSuggestion(value="suggester.ctx.get_str")
    public Object get(@CtxPathParam(unrecommended={CtxPathParam.CtxAttrType.VALUE}) String path) {
        Object obj = super.get(path);
        if (obj == null) {
            String name = this.getFirstToken(path);
            String subpath = this.skipFirstToken(path);
            obj = super.get(name);
            if (obj instanceof HigsonContext) {
                HigsonContext sub = (HigsonContext)obj;
                Object result = sub.get(subpath);
                obj = result != null ? result : sub.getNull();
            }
        }
        return obj;
    }

    @FetchSuggestion(value="suggester.ctx.getFirst")
    public Object getFirst(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.COLLECTION}) String path) {
        Iterator it;
        Object obj = this.get(path);
        if (obj instanceof Iterable && (it = ((Iterable)obj).iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    private String getFirstToken(String path) {
        return StringUtils.substringBefore(path, ".");
    }

    private String skipFirstToken(String path) {
        return StringUtils.substringAfter(path, ".");
    }

    protected Object getNull() {
        return null;
    }

    @FetchSuggestion(value="suggester.ctx.getStringHolder")
    public StringHolder getStringHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toStringHolder(this.get(path));
    }

    @Override
    @FetchSuggestion(value="suggester.ctx.getString")
    public String getString(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getStringHolder(path).getString();
    }

    @FetchSuggestion(value="suggester.ctx.getNumberHolder")
    public NumberHolder getNumberHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toNumberHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getDecimal")
    public BigDecimal getDecimal(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getNumberHolder(path).getBigDecimal();
    }

    @FetchSuggestion(value="suggester.ctx.getNumber")
    public double getNumber(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getNumberHolder(path).doubleValue();
    }

    @FetchSuggestion(value="suggester.ctx.getIntegerHolder")
    public IntegerHolder getIntegerHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toIntegerHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getInteger")
    public Integer getInteger(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.getInteger(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getDateHolder")
    public DateHolder getDateHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toDateHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getDate")
    public Date getDate(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getDateHolder(path).getDate();
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDateHolder")
    public LocalDateHolder getLocalDateHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toLocalDateHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDate")
    public LocalDate getLocalDate(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getLocalDateHolder(path).getLocalDate();
    }

    @FetchSuggestion(value="suggester.ctx.getDatetimeHolder")
    public DatetimeHolder getDatetimeHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toDatetimeHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getDatetime")
    public Date getDatetime(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getDatetimeHolder(path).getDatetime();
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDatetimeHolder")
    public LocalDateTimeHolder getLocalDatetimeHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toLocalDateTimeHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDatetime")
    public LocalDateTime getLocalDatetime(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getLocalDatetimeHolder(path).getLocalDateTime();
    }

    @FetchSuggestion(value="suggester.ctx.getBooleanHolder")
    public BooleanHolder getBooleanHolder(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return type.toBooleanHolder(this.get(path));
    }

    @FetchSuggestion(value="suggester.ctx.getBoolean")
    public boolean getBoolean(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String path) {
        return this.getBooleanHolder(path).booleanValue();
    }

    @FetchSuggestion(value="suggester.deprecated")
    public static void initialize(TypesDto dto) {
        stringType = dto.getStringType();
        numberType = dto.getNumberType();
        integerType = dto.getIntegerType();
        booleanType = dto.getBooleanType();
        dateType = dto.getDateType();
        datetimeType = dto.getDatetimeType();
        localDateType = dto.getLocalDateType();
        localDateTimeType = dto.getLocalDateTimeType();
    }

    @FetchSuggestion(value="suggester.ctx.getStringType")
    public static StringType getStringType() {
        return stringType;
    }

    @FetchSuggestion(value="suggester.ctx.getNumberType")
    public static NumberType getNumberType() {
        return numberType;
    }

    @FetchSuggestion(value="suggester.ctx.getIntegerType")
    public static IntegerType getIntegerType() {
        return integerType;
    }

    @FetchSuggestion(value="suggester.ctx.getBooleanType")
    public static BooleanType getBooleanType() {
        return booleanType;
    }

    @FetchSuggestion(value="suggester.ctx.getDateType")
    public static DateType getDateType() {
        return dateType;
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDateType")
    public static LocalDateType getLocalDateType() {
        return localDateType;
    }

    @FetchSuggestion(value="suggester.ctx.getDatetimeType")
    public static DatetimeType getDatetimeType() {
        return datetimeType;
    }

    @FetchSuggestion(value="suggester.ctx.getLocalDateTimeType")
    public static LocalDateTimeType getLocalDateTimeType() {
        return localDateTimeType;
    }

    @Override
    public String toString() {
        Map<String, Object> userCtx;
        StringBuilder sb = new StringBuilder(64);
        sb.append("HigsonContext[");
        if (this.getLevelValues() != null) {
            sb.append("levels=").append(Arrays.deepToString((Object[])this.getLevelValues()));
        }
        if ((userCtx = this.getUserContext()) != null && !userCtx.isEmpty()) {
            sb.append(" ctx=").append(userCtx.keySet());
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        type = TypeConverter.getInstance();
        SKIP_PARENT = new Object();
    }
}

