/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.domain;

import io.higson.runtime.dao.DomainCacheJdbcDao;
import io.higson.runtime.utils.DateFormatUtils;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpDomainRefreshController {
    private static final Logger log = LoggerFactory.getLogger(MpDomainRefreshController.class);
    protected final DomainCacheJdbcDao dao;
    protected Date mainTimestamp;
    protected Date regionVersionTimestamp;
    protected Date definitionTimestamp;
    protected Map<String, Date> timestampByProfile = new ConcurrentHashMap<String, Date>();

    public MpDomainRefreshController(DomainCacheJdbcDao dao) {
        this.dao = dao;
    }

    public boolean wasSomethingChange(Set<String> profiles) {
        log.trace("enter wasSomethingChange()");
        if (profiles.isEmpty()) {
            log.trace("no profiles to update");
            return false;
        }
        Date lastUpdate = this.getLastUpdate();
        if (this.isDomainChanged(lastUpdate)) {
            log.trace("something to change found - mainTimestamp set to {}", (Object)lastUpdate);
            this.mainTimestamp = lastUpdate;
            return true;
        }
        lastUpdate = this.getRegionLastUpdate();
        if (this.isRegionChanged(lastUpdate)) {
            log.trace("something to change found - regionVersionTimestamp set to {}", (Object)lastUpdate);
            this.regionVersionTimestamp = lastUpdate;
            return true;
        }
        lastUpdate = this.getDomainDefinitionLastUpdate();
        if (this.isDefinitionChanged(lastUpdate)) {
            log.trace("something to change found - definitionTimestamp set to {}", (Object)lastUpdate);
            this.definitionTimestamp = lastUpdate;
            return true;
        }
        return false;
    }

    private boolean isDefinitionChanged(Date lastUpdate) {
        return !lastUpdate.equals(this.definitionTimestamp);
    }

    private boolean isRegionChanged(Date lastUpdate) {
        if (log.isTraceEnabled()) {
            log.trace("isRegionChanged({}), regionVersionTimestamp {}", (Object)MpDomainRefreshController.print(lastUpdate), (Object)MpDomainRefreshController.print(this.regionVersionTimestamp));
        }
        return this.regionVersionTimestamp == null || Objects.isNull(lastUpdate) || lastUpdate.getTime() != this.regionVersionTimestamp.getTime();
    }

    private boolean isDomainChanged(Date lastUpdate) {
        return this.mainTimestamp == null || lastUpdate.getTime() != this.mainTimestamp.getTime();
    }

    private Date getDomainDefinitionLastUpdate() {
        Date lastUpdate = this.dao.getDomainDefinitionLastUpdate();
        if (lastUpdate == null) {
            lastUpdate = new Date();
        }
        return lastUpdate;
    }

    private Date getRegionLastUpdate() {
        Date lastUpdate = this.dao.getRegionVersionLastUpdate();
        if (lastUpdate == null) {
            lastUpdate = new Date();
        }
        return lastUpdate;
    }

    private Date getLastUpdate() {
        Date lastUpdate = this.dao.getDomainElementLastUpdate();
        if (lastUpdate == null) {
            lastUpdate = new Date();
        }
        return lastUpdate;
    }

    public Set<String> getPossibleModification(Map<String, Date> lastUpdatesByProfile, Set<String> profiles) {
        log.trace("enter possibleModification({})", (Object)lastUpdatesByProfile);
        TreeSet<String> profilesToUpdate = new TreeSet<String>();
        for (Map.Entry<String, Date> lastUpdate : lastUpdatesByProfile.entrySet()) {
            if (!profiles.contains(lastUpdate.getKey()) || this.timestampByProfile.containsKey(lastUpdate.getKey()) && this.timestampByProfile.get(lastUpdate.getKey()).equals(lastUpdate.getValue())) continue;
            profilesToUpdate.add(lastUpdate.getKey());
        }
        for (Map.Entry<String, Date> savedLastUpdate : this.timestampByProfile.entrySet()) {
            if (lastUpdatesByProfile.containsKey(savedLastUpdate.getKey())) continue;
            profilesToUpdate.add(savedLastUpdate.getKey());
        }
        if (!profilesToUpdate.isEmpty()) {
            log.trace("these profiles should be reloaded: {}", (Object)profilesToUpdate);
        }
        return profilesToUpdate;
    }

    public void updateTimestampByProfile(Map<String, Date> lastUpdatesByProfile, String profile2) {
        if (lastUpdatesByProfile.get(profile2) != null) {
            this.timestampByProfile.put(profile2, lastUpdatesByProfile.get(profile2));
            if (log.isDebugEnabled()) {
                log.debug("{} last update set to: {}", (Object)profile2, (Object)MpDomainRefreshController.print(lastUpdatesByProfile.get(profile2)));
            }
        } else {
            this.timestampByProfile.remove(profile2);
            log.debug(" delete last update for: {}", (Object)profile2);
        }
    }

    public static String print(Date d) {
        return Objects.isNull(d) ? null : DateFormatUtils.formatDateTimeWithMillis(d);
    }

    public Map<String, Date> getLastUpdatesByProfile() {
        return this.dao.getProfileLastUpdates();
    }

    public void updateTimestampsForProfile(String profileCode) {
        Date tmp = this.dao.getLastUpdateForProfile(profileCode);
        this.updateTimestampForProfile(profileCode, tmp);
    }

    protected void updateTimestampForProfile(String profileCode, Date tmp) {
        if (tmp == null) {
            return;
        }
        Date lastUpdate = DateUtils.truncate(tmp, 14);
        this.timestampByProfile.put(profileCode, lastUpdate);
        if (log.isTraceEnabled()) {
            log.trace("updateTimestampsForProfile - {}:{}", (Object)profileCode, (Object)MpDomainRefreshController.print(lastUpdate));
        }
    }

    public Date getSessionProfileChangeTimestamp(String profileCode, String user) {
        return this.dao.getLastUpdateForOpenSession(profileCode, user);
    }
}

