/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.ext;

import io.higson.runtime.core.EmptyParamValue;
import io.higson.runtime.core.ext.ParamValueProxy;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.output.ParamValueImpl;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.model.ObjectValueHolder;
import io.higson.runtime.rhino.value.RhinoMultiValue;
import io.higson.runtime.rhino.value.RhinoParamValue;
import org.apache.commons.lang3.StringUtils;

public class ParamValueProxyFactory {
    private static final ParamValueProxy EMPTY_PROXY = new ParamValueProxy(new EmptyParamValue());

    private ParamValueProxyFactory() {
        throw new UnsupportedOperationException();
    }

    public static ParamValueProxy get(Object value) {
        if (value instanceof ParamValueProxy) {
            return (ParamValueProxy)value;
        }
        if (value instanceof ParamValue) {
            return new ParamValueProxy((ParamValue)value);
        }
        if (value instanceof RhinoParamValue) {
            return ParamValueProxyFactory.toProxy((RhinoParamValue)value);
        }
        if (value instanceof MultiValue) {
            return ParamValueProxyFactory.toProxy((MultiValue)value);
        }
        if (value instanceof MultiValue[]) {
            return ParamValueProxyFactory.toProxy((MultiValue[])value);
        }
        if (value instanceof RhinoMultiValue) {
            return ParamValueProxyFactory.toProxy((RhinoMultiValue)value);
        }
        if (value instanceof ValueHolder) {
            return ParamValueProxyFactory.toProxy((ValueHolder)value);
        }
        if (ParamValueProxyFactory.isNullOrBlank(value)) {
            return EMPTY_PROXY;
        }
        return ParamValueProxyFactory.toProxy(new ObjectValueHolder(value));
    }

    private static ParamValueProxy toProxy(ParamValue pv) {
        return new ParamValueProxy(pv);
    }

    private static ParamValueProxy toProxy(RhinoParamValue rpv) {
        return ParamValueProxyFactory.toProxy(rpv.unwrap());
    }

    private static ParamValueProxy toProxy(MultiValue mv) {
        return ParamValueProxyFactory.toProxy(new ParamValueImpl(mv));
    }

    private static ParamValueProxy toProxy(MultiValue[] mv) {
        return ParamValueProxyFactory.toProxy(new ParamValueImpl(mv));
    }

    private static ParamValueProxy toProxy(RhinoMultiValue rmv) {
        return ParamValueProxyFactory.toProxy(rmv.raw());
    }

    private static ParamValueProxy toProxy(ValueHolder holder) {
        return ParamValueProxyFactory.toProxy(new MultiValue(holder));
    }

    private static boolean isNullOrBlank(Object value) {
        if (value instanceof String) {
            return StringUtils.isBlank((String)value);
        }
        return value == null;
    }
}

