/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.extdatasource;

import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public class ExternalDataSourceProvider {
    private final Map<String, DataSource> externalDataSourceMap = new LinkedHashMap<String, DataSource>();

    public ExternalDataSourceProvider withExternalDataSource(String code, DataSource dataSource) {
        this.externalDataSourceMap.put(code, dataSource);
        return this;
    }

    public DataSource getDataSource(String code) {
        if (code != null) {
            return this.externalDataSourceMap.get(code);
        }
        throw new HigsonRuntimeException("DataSource code not provided");
    }

    public boolean hasExternalDataSources() {
        return !this.externalDataSourceMap.isEmpty();
    }

    public Collection<String> listExternalDataSources() {
        return this.externalDataSourceMap.keySet();
    }
}

