/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao;

import io.higson.runtime.dao.BaseDao;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Schedule;
import io.higson.runtime.model.ScheduleEntry;
import io.higson.runtime.model.UserRegionVersion;
import io.higson.runtime.model.region.ScheduleContainer;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionJdbcDao
extends BaseDao {
    private static final Logger log = LoggerFactory.getLogger(VersionJdbcDao.class);
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();

    public VersionJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
        this.setDefaultFetchSize(100);
    }

    public java.util.Date getMaxLastUpdate() {
        return this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @regionversion"), java.util.Date.class);
    }

    public Map<Integer, RegionVersion> getAllRegionVersions() {
        List<RegionVersion> all = this.getAllRegionVersionsList();
        HashMap<Integer, RegionVersion> map = new HashMap<Integer, RegionVersion>((int)((float)all.size() / 0.75f) + 1);
        for (RegionVersion v : all) {
            map.put(v.getId(), v);
        }
        return map;
    }

    public List<RegionVersion> getAllRegionVersionsList() {
        String sql = this.dialect.parse(" select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate from @regionversion rv inner join @region r on rv.region_id = r.id where rv.$archive = 0   and r.$archive = 0");
        return this.jdbcTemplate().query(sql, (rs, i) -> this.createVersion(rs));
    }

    public List<RegionVersion> getAllRegionVersionsList(String profileCode) {
        String sql = this.dialect.parse(" select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate from @regionversion rv inner join @region r on rv.region_id = r.id where rv.$archive = 0   and r.$archive = 0   and r.profile_code = ?");
        return this.jdbcTemplate().query(sql, new Object[]{profileCode.toUpperCase()}, (rs, i) -> this.createVersion(rs));
    }

    private RegionVersion createVersion(ResultSet rs) throws SQLException {
        int vid = rs.getInt("id");
        int rid = rs.getInt("region_id");
        String region = rs.getString("code");
        String profileCode = rs.getString("profile_code");
        String version = rs.getString("versionnumber");
        boolean active = rs.getBoolean("active");
        Timestamp lastupdate = rs.getTimestamp("lastupdate");
        return new RegionVersion(vid, rid, region, version, active, lastupdate, profileCode);
    }

    public Set<String> getFunctionsWithRegion(int regionId) {
        HashSet<String> result = new HashSet<String>();
        String sql = " select distinct f.$name from @hyp_function f   inner join @regionversion rv on f.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where f.$archive = 0   and r.id = ?";
        sql = this.dialect.parse(sql);
        this.jdbcTemplate().query(sql, new Object[]{regionId}, rs -> result.add(rs.getString(1)));
        return result;
    }

    public Set<String> getParametersWithRegion(int regionId) {
        HashSet<String> result = new HashSet<String>();
        String sql = " select distinct p.$name  from @parameter p   inner join @regionversion rv on p.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where p.$archive = 0       and r.id = ?";
        sql = this.dialect.parse(sql);
        this.jdbcTemplate().query(sql, new Object[]{regionId}, rs -> result.add(rs.getString(1)));
        return result;
    }

    public Map<String, ScheduleContainer> getAllSchedules() {
        HashMap<String, ScheduleContainer> map = new HashMap<String, ScheduleContainer>();
        this.jdbcTemplate().query(this.dialect.parse("select r.id, r.code, r.profile_code from @region r where r.archive = 0"), rs -> {
            String region = rs.getString("code");
            String profileCode = rs.getString("profile_code");
            map.computeIfAbsent(profileCode, code -> this.createScheduleContainer((String)code, region)).add(region, new Schedule(profileCode, region));
        });
        String sql = this.dialect.parse(" select r.code, r.profile_code, rv.versionnumber, s.regionversion_id, s.validfrom  from @regionversionschedule s    inner join @regionversion rv on s.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where rv.archive = 0 and r.archive = 0 order by s.validfrom");
        this.jdbcTemplate().query(sql, rs -> this.addEntry(map, rs));
        return map;
    }

    private void addEntry(Map<String, ScheduleContainer> map, ResultSet rs) throws SQLException {
        String region = rs.getString("code");
        String profileCode = rs.getString("profile_code");
        String ver = rs.getString("versionnumber");
        Date validFrom = this.dialect.getTimestamp(rs, "validfrom");
        this.getSchedule(map, profileCode, region).addEntry(new ScheduleEntry(region, ver, validFrom));
    }

    public List<RegionVersion> getUserRegionVersions(String profileCode, String user) {
        String query = "select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate from @UserRegionVersion  urv inner join @regionversion rv on rv.id=urv.regionversion_id inner join @region r on r.id=rv.region_id where urv.username=?  and rv.archive=0  and r.archive=0  and r.profile_code=?";
        String sql = this.dialect.parse(query);
        return this.jdbcTemplate().query(sql, (rs, i) -> this.createVersion(rs), user, profileCode);
    }

    public List<UserRegionVersion> getAllUserRegionVersions() {
        String sql = this.dialect.parse("select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate, urv.userName from @UserRegionVersion  urv inner join @regionversion rv on rv.id=urv.regionversion_id inner join @region r on r.id=rv.region_id  and rv.archive=0  and r.archive=0");
        ArrayList<UserRegionVersion> userRegionVersions = new ArrayList<UserRegionVersion>();
        this.jdbcTemplate().query(sql, (rs, i) -> userRegionVersions.add(new UserRegionVersion(rs.getString("userName"), this.createVersion(rs))));
        return userRegionVersions;
    }

    public SortedSet<Integer> getSystemVersions(String profile2, SortedSet<Integer> versionsToOmit) {
        log.trace("entering get system versions (profile={},versionsToOmit={})", (Object)profile2, (Object)versionsToOmit);
        StringBuilder query = new StringBuilder("select rv.id as regionVersionId");
        query.append(" from @RegionVersion rv");
        query.append(" inner join @region r on r.id=rv.region_id");
        query.append(" where rv.active=1 and rv.archive=0");
        query.append(" and r.archive=0 and r.profile_code=?");
        if (!versionsToOmit.isEmpty()) {
            query.append(" and rv.region_id not in (");
            query.append(" select r2.region_id from @regionversion r2 where r2.id in (");
            query.append(this.getIdsToIn(versionsToOmit));
            query.append(" ) )");
        }
        String sql = this.dialect.parse(query.toString());
        TreeSet<Integer> result = new TreeSet<Integer>();
        this.jdbcTemplate().query(sql, (rs, i) -> {
            int idTmp = rs.getInt("regionVersionId");
            result.add(idTmp);
            return null;
        }, profile2);
        return result;
    }

    private String getIdsToIn(Set<Integer> userRegionVersions) {
        StringBuilder result = new StringBuilder();
        for (Integer ver : userRegionVersions) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(ver);
        }
        return result.toString();
    }

    private ScheduleContainer createScheduleContainer(String profileCode, String region) {
        Schedule schedule = new Schedule(profileCode, region);
        ScheduleContainer container = new ScheduleContainer();
        container.add(region, schedule);
        return container;
    }

    private Schedule getSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return map.computeIfAbsent(profileCode, code -> this.createScheduleContainerWithSchedule((String)code, regionCode)).getSchedule(regionCode).orElseGet(this.createSchedule(map, profileCode, regionCode));
    }

    private ScheduleContainer createScheduleContainerWithSchedule(String profileCode, String regionCode) {
        ScheduleContainer container = new ScheduleContainer();
        Schedule schedule = new Schedule(profileCode, regionCode);
        container.add(regionCode, schedule);
        return container;
    }

    private Supplier<Schedule> createSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return () -> {
            Schedule schedule = new Schedule(profileCode, regionCode);
            ((ScheduleContainer)map.get(profileCode)).add(regionCode, schedule);
            return schedule;
        };
    }

    public List<String> getProfiles(String regionCode) {
        ArrayList<String> profiles = new ArrayList<String>();
        String sql = this.dialect.parse(" select r.profile_code from @region r where r.code = ? and r.$archive = 0");
        this.jdbcTemplate().query(sql, rs -> profiles.add(rs.getString("profile_code")), regionCode);
        return profiles;
    }

    public List<String> getProfiles(String regionCode, String version) {
        ArrayList<String> profiles = new ArrayList<String>();
        String sql = this.dialect.parse(" select r.profile_code from @region r inner join @regionversion rv on rv.region_id = r.id where r.code = ? and r.$archive = 0 and rv.versionnumber = ? and rv.$archive = 0");
        this.jdbcTemplate().query(sql, rs -> profiles.add(rs.getString("profile_code")), regionCode, version);
        return profiles;
    }
}

