/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;

final class GetNamesByRegionsInProfilesQueryBuilder {
    GetNamesByRegionsInProfilesQueryBuilder() {
    }

    MutablePair<String, List<Object>> build(Map<String, List<String>> profileToRegions) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("select $name as paramName from @parameter where regionversion_id in (");
        queryBuilder.append("select rv.id as regionVersionId from @RegionVersion rv inner join @region r on r.id=rv.region_id where rv.active=1 and rv.archive=0 and r.archive=0 and (");
        String[] profilesCodes = profileToRegions.keySet().toArray(new String[0]);
        ArrayList<Object> queryParams = new ArrayList<Object>();
        this.appendFirst(queryBuilder, profilesCodes[0], profileToRegions.get(profilesCodes[0]), queryParams);
        for (int i = 1; i < profilesCodes.length; ++i) {
            String profileCode = profilesCodes[i];
            List<String> regionsCodes = profileToRegions.get(profileCode);
            this.appendNext(queryBuilder, profileCode, regionsCodes, queryParams);
        }
        queryBuilder.append(")");
        queryBuilder.append(")");
        return new MutablePair<String, List<Object>>(queryBuilder.toString(), queryParams);
    }

    private void appendFirst(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        if (regionsCodes.size() > 1000) {
            this.partitionAndAppendFirst(queryBuilder, profileCode, regionsCodes, queryParams);
            return;
        }
        this.append(queryBuilder, profileCode, regionsCodes, queryParams);
    }

    private void partitionAndAppendFirst(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        List<List<String>> partitions = ListUtils.partition(regionsCodes, 1000);
        List<String> firstPartition = partitions.get(0);
        this.append(queryBuilder, profileCode, firstPartition, queryParams);
        for (int i = 1; i < partitions.size(); ++i) {
            List<String> partition = partitions.get(i);
            this.appendOr(queryBuilder, profileCode, partition, queryParams);
        }
    }

    private void appendNext(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        if (regionsCodes.size() > 1000) {
            this.partitionAndAppendNext(queryBuilder, profileCode, regionsCodes, queryParams);
            return;
        }
        this.appendOr(queryBuilder, profileCode, regionsCodes, queryParams);
    }

    private void partitionAndAppendNext(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        List<List<String>> partitions = ListUtils.partition(regionsCodes, 1000);
        for (List<String> partition : partitions) {
            this.appendOr(queryBuilder, profileCode, partition, queryParams);
        }
    }

    private void append(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        queryBuilder.append("(r.profile_code=? and r.code in (" + StringUtils.repeat("?", ",", regionsCodes.size()) + "))");
        queryParams.add(profileCode);
        queryParams.add(regionsCodes.toArray());
    }

    private void appendOr(StringBuilder queryBuilder, String profileCode, List<String> regionsCodes, List<Object> queryParams) {
        queryBuilder.append(" or (r.profile_code=? and r.code in (" + StringUtils.repeat("?", ",", regionsCodes.size()) + "))");
        queryParams.add(profileCode);
        queryParams.add(regionsCodes.toArray());
    }
}

